/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.installation.UnlinkInstallationCommand;
import io.gravitee.cockpit.api.command.installation.UnlinkInstallationPayload;
import io.gravitee.cockpit.api.command.installation.UnlinkInstallationReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import io.reactivex.rxjava3.core.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UnlinkInstallationCommandHandler
implements CommandHandler<UnlinkInstallationCommand, UnlinkInstallationReply> {
    private final Logger logger = LoggerFactory.getLogger(UnlinkInstallationCommandHandler.class);
    private final OrganizationService organizationService;
    private final EnvironmentService environmentService;
    private final AccessPointCrudService accessPointService;

    public UnlinkInstallationCommandHandler(OrganizationService organizationService, EnvironmentService environmentService, AccessPointCrudService accessPointService) {
        this.organizationService = organizationService;
        this.environmentService = environmentService;
        this.accessPointService = accessPointService;
    }

    public Command.Type handleType() {
        return Command.Type.UNLINK_INSTALLATION_COMMAND;
    }

    public Single<UnlinkInstallationReply> handle(UnlinkInstallationCommand command) {
        UnlinkInstallationPayload unlinkInstallationPayload = (UnlinkInstallationPayload)command.getPayload();
        try {
            if (unlinkInstallationPayload.getOrganizationCockpitId() != null) {
                OrganizationEntity organization = this.organizationService.findByCockpitId(unlinkInstallationPayload.getOrganizationCockpitId());
                this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organization.getId());
            }
            if (unlinkInstallationPayload.getEnvironmentCockpitId() != null) {
                EnvironmentEntity environment = this.environmentService.findByCockpitId(unlinkInstallationPayload.getEnvironmentCockpitId());
                this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environment.getId());
            }
            return Single.just((Object)new UnlinkInstallationReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception ex) {
            this.logger.info("Error occurred when unlink installation.", (Throwable)ex);
            return Single.just((Object)new UnlinkInstallationReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

