/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.parser;

import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.swagger.parser.AbstractDescriptorParser;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIParser
extends AbstractDescriptorParser<OAIDescriptor> {
    private final Logger logger = LoggerFactory.getLogger(OAIParser.class);

    public OAIDescriptor parse(String content, ParseOptions options) {
        OpenAPIParser parser = new OpenAPIParser();
        String path = content;
        Path tmp = null;
        if (!OAIParser.isLocationUrl(content)) {
            try {
                tmp = this.createTempFile(content);
                path = tmp.toAbsolutePath().toString();
            }
            catch (RuntimeException e) {
                this.logger.warn("Unable to create temporary file, raw content will be passed to OAI parser: {}", (Object)e.getMessage());
            }
        }
        SwaggerParseResult parseResult = parser.readLocation(path, null, options);
        if (tmp != null) {
            this.deleteTempFile(tmp);
        }
        if (parseResult.getMessages() != null) {
            List filteredMessages = parseResult.getMessages().stream().filter(message -> message != null && !message.matches("^attribute info.contact.*")).collect(Collectors.toList());
            parseResult.setMessages(filteredMessages);
        }
        if (parseResult.getOpenAPI() == null) {
            throw new SwaggerDescriptorException("Malformed descriptor");
        }
        OAIDescriptor descriptor = new OAIDescriptor(parseResult.getOpenAPI());
        descriptor.setMessages(parseResult.getMessages());
        return descriptor;
    }

    @Override
    public OAIDescriptor parse(String content) {
        return this.parse(content, null);
    }

    private Path createTempFile(String content) {
        Path temp = this.createSecuredTempFile();
        try (FileWriter out = new FileWriter(temp.toFile());
             BufferedWriter bw = new BufferedWriter(out);){
            bw.write(content);
        }
        catch (IOException ioe) {
            throw new TechnicalManagementException("An error occurs while trying to create temp file", ioe);
        }
        return temp;
    }

    private Path createSecuredTempFile() {
        String fileName = "gio_swagger_" + UuidString.generateRandom() + "_" + System.currentTimeMillis();
        if (SystemUtils.IS_OS_UNIX) {
            return this.createPosixSecuredFile(fileName);
        }
        return this.createNonPosixSecuredFile(fileName);
    }

    private Path createPosixSecuredFile(String fileName) {
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
        try {
            return Files.createTempFile(fileName, ".tmp", attr);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path createNonPosixSecuredFile(String fileName) {
        try {
            Path path = Files.createTempFile(fileName, ".tmp", new FileAttribute[0]);
            this.setNonPosixPermissions(path.toFile());
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void setNonPosixPermissions(File file) {
        if (!(file.setReadable(true, true) && file.setWritable(true, true) && file.setExecutable(false))) {
            this.logger.warn("Unable to set permissions on file {}, using default permissions", (Object)file.getAbsolutePath());
        }
    }

    private void deleteTempFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            this.logger.warn("Unable to delete temporary file {}", (Object)path);
        }
    }

    static {
        System.setProperty(String.format("%s.trustAll", RemoteUrl.class.getName()), Boolean.TRUE.toString());
    }
}

