/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.rest.api.service.V4EmulationEngineService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class V4EmulationEngineServiceImpl
implements V4EmulationEngineService {
    private final V4EmulationEngineService.DefaultMode defaultMode;

    public V4EmulationEngineServiceImpl(@Value(value="${api.v2.emulateV4Engine.default:yes}") String defaultMode) {
        this.defaultMode = V4EmulationEngineService.DefaultMode.fromLabel(defaultMode);
    }

    @Override
    public V4EmulationEngineService.DefaultMode defaultMode() {
        return this.defaultMode;
    }

    @Override
    public ExecutionMode getExecutionModeFor(JsonNode apiDefinition) {
        if (this.defaultMode == V4EmulationEngineService.DefaultMode.YES || apiDefinition == null && this.defaultMode == V4EmulationEngineService.DefaultMode.CREATION_ONLY) {
            return ExecutionMode.V4_EMULATION_ENGINE;
        }
        return ExecutionMode.V3;
    }
}

