/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import java.util.stream.Collectors;

public class ApiSearchCriteriaAdapter {
    public static ApiSearchCriteriaAdapter INSTANCE = new ApiSearchCriteriaAdapter();

    private ApiSearchCriteriaAdapter() {
    }

    public ApiCriteria toCriteriaForRepository(ApiSearchCriteria criteria) {
        ApiCriteria.Builder builder = new ApiCriteria.Builder();
        if (criteria != null) {
            if (criteria.getIds() != null && !criteria.getIds().isEmpty()) {
                builder.ids(criteria.getIds());
            }
            if (criteria.getState() != null) {
                builder.state(LifecycleState.valueOf((String)criteria.getState().name()));
            }
            if (criteria.getVisibility() != null) {
                builder.visibility(Visibility.valueOf((String)criteria.getVisibility().name()));
            }
            if (criteria.getLifecycleStates() != null && !criteria.getLifecycleStates().isEmpty()) {
                builder.lifecycleStates(criteria.getLifecycleStates().stream().map(s -> ApiLifecycleState.valueOf((String)s.name())).collect(Collectors.toList()));
            }
            if (criteria.getDefinitionVersion() != null && !criteria.getDefinitionVersion().isEmpty()) {
                builder.definitionVersion(criteria.getDefinitionVersion().stream().map(v -> DefinitionVersion.valueOf((String)v.name())).toList());
            }
            builder.groups(criteria.getGroups()).category(criteria.getCategory()).label(criteria.getLabel()).version(criteria.getVersion()).name(criteria.getName()).environmentId(criteria.getEnvironmentId()).environments(criteria.getEnvironments()).crossId(criteria.getCrossId());
        }
        return builder.build();
    }
}

