/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointGroupServices;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointServices;
import io.gravitee.definition.model.v4.service.Service;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.exceptions.EndpointConfigurationValidationException;
import io.gravitee.rest.api.service.exceptions.EndpointGroupNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.EndpointMissingException;
import io.gravitee.rest.api.service.exceptions.EndpointNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.EndpointNameInvalidException;
import io.gravitee.rest.api.service.exceptions.HealthcheckInheritanceException;
import io.gravitee.rest.api.service.exceptions.HealthcheckInvalidException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.ApiServicePluginService;
import io.gravitee.rest.api.service.v4.EndpointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.EndpointGroupTypeInvalidException;
import io.gravitee.rest.api.service.v4.exception.EndpointGroupTypeMismatchInvalidException;
import io.gravitee.rest.api.service.v4.exception.EndpointTypeInvalidException;
import io.gravitee.rest.api.service.v4.validation.EndpointGroupsValidationService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EndpointGroupsValidationServiceImpl
extends TransactionalService
implements EndpointGroupsValidationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EndpointConnectorPluginService endpointService;
    private final ApiServicePluginService apiServicePluginService;

    public EndpointGroupsValidationServiceImpl(EndpointConnectorPluginService endpointService, ApiServicePluginService apiServicePluginService) {
        this.endpointService = endpointService;
        this.apiServicePluginService = apiServicePluginService;
    }

    @Override
    public List<EndpointGroup> validateAndSanitize(List<EndpointGroup> endpointGroups) {
        if (endpointGroups == null || endpointGroups.isEmpty()) {
            throw new EndpointMissingException();
        }
        HashSet names = new HashSet();
        endpointGroups.forEach(endpointGroup -> {
            this.validateUniqueEndpointGroupName(endpointGroup.getName(), names);
            this.validateEndpointGroupType(endpointGroup.getType());
            this.validateServices(endpointGroup.getServices());
            this.validateEndpointsExistence((EndpointGroup)endpointGroup);
            ConnectorPluginEntity endpointConnector = (ConnectorPluginEntity)this.endpointService.findById(endpointGroup.getType());
            if (endpointGroup.getSharedConfiguration() != null) {
                endpointGroup.setSharedConfiguration(this.endpointService.validateSharedConfiguration(endpointConnector, endpointGroup.getSharedConfiguration()));
            }
            if (endpointGroup.getEndpoints() != null && !endpointGroups.isEmpty()) {
                endpointGroup.getEndpoints().forEach(endpoint -> {
                    this.validateUniqueEndpointName(endpoint.getName(), names);
                    this.validateEndpointType(endpoint.getType());
                    this.validateServices(endpointGroup.getServices(), endpoint.getServices());
                    this.validateEndpointMatchType((EndpointGroup)endpointGroup, (Endpoint)endpoint);
                    this.validateEndpointConfiguration(endpointConnector, (Endpoint)endpoint);
                    this.validateSharedConfigurationInheritance((EndpointGroup)endpointGroup, (Endpoint)endpoint);
                    this.validateSharedConfigurationOverride(endpointConnector, (Endpoint)endpoint);
                });
            }
        });
        return endpointGroups;
    }

    private void validateEndpointConfiguration(ConnectorPluginEntity endpointConnector, Endpoint endpoint) {
        endpoint.setConfiguration(this.endpointService.validateConnectorConfiguration(endpointConnector, endpoint.getConfiguration()));
    }

    private void validateSharedConfigurationOverride(ConnectorPluginEntity endpointConnector, Endpoint endpoint) {
        if (!endpoint.isInheritConfiguration()) {
            if (endpoint.getSharedConfigurationOverride() == null) {
                this.endpointService.validateSharedConfiguration(endpointConnector, "{}");
            } else {
                endpoint.setSharedConfigurationOverride(this.endpointService.validateSharedConfiguration(endpointConnector, endpoint.getSharedConfigurationOverride()));
            }
        }
    }

    private void validateSharedConfigurationInheritance(EndpointGroup endpointGroup, Endpoint endpoint) {
        if (endpoint.isInheritConfiguration() && endpointGroup.getSharedConfiguration() == null) {
            throw new EndpointConfigurationValidationException("Impossible to inherit from a null shared configuration for endpoint: " + endpoint.getName());
        }
    }

    private void validateEndpointsExistence(EndpointGroup endpointGroup) {
        Service endpointDiscoveryService;
        Service service = endpointDiscoveryService = endpointGroup.getServices() == null ? null : endpointGroup.getServices().getDiscovery();
        if (!(endpointDiscoveryService != null && endpointDiscoveryService.isEnabled() || endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty())) {
            throw new EndpointMissingException();
        }
    }

    private void validateDiscovery(Service discovery) {
    }

    private void validateEndpointType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new EndpointTypeInvalidException(type);
        }
    }

    private void validateEndpointGroupType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new EndpointGroupTypeInvalidException(type);
        }
    }

    private void validateEndpointMatchType(EndpointGroup endpointGroup, Endpoint endpoint) {
        if (!endpointGroup.getType().equals(endpoint.getType())) {
            throw new EndpointGroupTypeMismatchInvalidException(endpointGroup.getType());
        }
    }

    private void validateHealthCheck(Service healthCheck) {
        if (StringUtils.isBlank((CharSequence)healthCheck.getType())) {
            this.logger.debug("HealthCheck requires a type");
            throw new HealthcheckInvalidException(healthCheck.getType());
        }
        healthCheck.setConfiguration(this.apiServicePluginService.validateApiServiceConfiguration(healthCheck.getType(), healthCheck.getConfiguration()));
    }

    private void validateName(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    private void validateUniqueEndpointGroupName(String name, Set<String> names) {
        this.validateName(name);
        if (names.contains(name)) {
            throw new EndpointGroupNameAlreadyExistsException(name);
        }
        names.add(name);
    }

    private void validateUniqueEndpointName(String name, Set<String> names) {
        this.validateName(name);
        if (names.contains(name)) {
            throw new EndpointNameAlreadyExistsException(name);
        }
        names.add(name);
    }

    private void validateServices(EndpointGroupServices services) {
        if (services != null) {
            if (services.getDiscovery() != null) {
                this.validateDiscovery(services.getDiscovery());
            }
            if (services.getHealthCheck() != null) {
                this.validateHealthCheck(services.getHealthCheck());
            }
        }
    }

    private void validateServices(EndpointGroupServices groupServices, EndpointServices services) {
        if (services != null && services.getHealthCheck() != null) {
            boolean hcGroupWithoutConfig;
            Service serviceHealthCheck = services.getHealthCheck();
            this.validateHealthCheck(serviceHealthCheck);
            boolean bl = hcGroupWithoutConfig = groupServices == null || groupServices.getHealthCheck() == null || StringUtils.isBlank((CharSequence)groupServices.getHealthCheck().getConfiguration());
            if (!serviceHealthCheck.isOverrideConfiguration() && hcGroupWithoutConfig) {
                this.logger.debug("HealthCheck inherit from a missing configuration");
                throw new HealthcheckInheritanceException();
            }
            if (serviceHealthCheck.isOverrideConfiguration() && StringUtils.isBlank((CharSequence)serviceHealthCheck.getConfiguration())) {
                this.logger.debug("HealthCheck requires a configuration when overrideConfiguration is enabled");
                throw new HealthcheckInheritanceException();
            }
            if (groupServices != null && groupServices.getHealthCheck() != null && !serviceHealthCheck.getType().equals(groupServices.getHealthCheck().getType())) {
                this.logger.debug("HealthCheck with type [{}] inherit configuration from another HealthCheck type [{}]", (Object)serviceHealthCheck.getType(), (Object)groupServices.getHealthCheck().getType());
                throw new HealthcheckInheritanceException();
            }
        }
    }
}

