/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.apim.infra.template.TemplateProcessor;
import io.gravitee.apim.infra.template.TemplateProcessorException;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notifiers.EmailNotifierService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailNotifierServiceImpl
implements EmailNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(EmailNotifierServiceImpl.class);
    private final EmailService emailService;
    private final TemplateProcessor templateProcessor;

    public EmailNotifierServiceImpl(@Autowired EmailService emailService, @Autowired TemplateProcessor templateProcessor) {
        this.emailService = emailService;
        this.templateProcessor = templateProcessor;
    }

    @Override
    public void trigger(ExecutionContext executionContext, Hook hook, Map<String, Object> templateData, List<String> recipients) {
        Optional<EmailNotificationBuilder.EmailTemplate> emailTemplate = this.getEmailTemplateOptional(hook);
        if (emailTemplate.isEmpty()) {
            this.LOGGER.error("Email template not found for hook {}", (Object)hook);
            return;
        }
        Set<String> mails = this.extractMailsFromRecipient(templateData, recipients);
        if (mails.isEmpty()) {
            this.LOGGER.error("No emails extracted from {}", recipients);
            return;
        }
        EmailNotificationBuilder template = new EmailNotificationBuilder().template(emailTemplate.get()).params(templateData);
        if (mails.size() == 1) {
            template.to(mails.toArray(new String[0]));
        } else {
            template.bcc(mails.toArray(new String[0]));
        }
        this.emailService.sendAsyncEmailNotification(executionContext, template.build());
    }

    private Optional<EmailNotificationBuilder.EmailTemplate> getEmailTemplateOptional(Hook hook) {
        if (hook == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(EmailNotificationBuilder.EmailTemplate.fromHook(hook));
    }

    public Set<String> extractMailsFromRecipient(Map<String, Object> templateData, List<String> recipients) {
        Stream collect = recipients.stream().flatMap(recipient -> Arrays.stream(recipient.split(",|;|\\s")).filter(s -> !s.isEmpty()).map(s -> {
            if (s.contains("$")) {
                try {
                    return Optional.ofNullable(this.templateProcessor.processInlineTemplate((String)s, templateData));
                }
                catch (TemplateProcessorException e) {
                    this.LOGGER.error("Error while processing template '{}' skipping this email", s, (Object)e);
                    return Optional.empty();
                }
            }
            return Optional.of(s);
        }));
        return collect.filter(s -> s.isPresent() && !((String)s.get()).isEmpty()).map(Optional::get).collect(Collectors.toSet());
    }
}

