/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.log;

import io.gravitee.apim.core.log.crud_service.MessageLogCrudService;
import io.gravitee.apim.core.log.model.AggregatedMessageLog;
import io.gravitee.apim.infra.adapter.MessageLogAdapter;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.log.v4.api.LogRepository;
import io.gravitee.repository.log.v4.model.LogResponse;
import io.gravitee.repository.log.v4.model.message.MessageLogQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.v4.log.SearchLogsResponse;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
class MessageLogCrudServiceImpl
implements MessageLogCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageLogCrudServiceImpl.class);
    private final LogRepository logRepository;

    public MessageLogCrudServiceImpl(@Lazy LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    @Override
    public SearchLogsResponse<AggregatedMessageLog> searchApiMessageLog(String apiId, String requestId, Pageable pageable) {
        try {
            LogResponse response = this.logRepository.searchAggregatedMessageLog(MessageLogQuery.builder().filter(MessageLogQuery.Filter.builder().apiId(apiId).requestId(requestId).build()).page(pageable.getPageNumber()).size(pageable.getPageSize()).build());
            return this.mapToMessageResponse((LogResponse<io.gravitee.repository.log.v4.model.message.AggregatedMessageLog>)response);
        }
        catch (AnalyticsException e) {
            log.error("An error occurs while trying to search message of api [apiId={}, requestId={}]", new Object[]{apiId, requestId, e});
            throw new TechnicalManagementException("Error while searching message logs of api " + apiId + " request " + requestId, e);
        }
    }

    private SearchLogsResponse<AggregatedMessageLog> mapToMessageResponse(LogResponse<io.gravitee.repository.log.v4.model.message.AggregatedMessageLog> logs) {
        long total = logs.total();
        List<AggregatedMessageLog> data = MessageLogAdapter.INSTANCE.toEntities(logs.data());
        return new SearchLogsResponse(total, data);
    }
}

