/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.DocumentationValidationDomainService;
import io.gravitee.apim.core.documentation.domain_service.HomepageDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageParentException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ApiCreateDocumentationPageUseCase {
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final HomepageDomainService homepageDomainService;
    private final PageCrudService pageCrudService;
    private final PageQueryService pageQueryService;
    private final DocumentationValidationDomainService documentationValidationDomainService;

    public Output execute(Input input) {
        Page pageToCreate = input.page;
        pageToCreate.setId(UuidString.generateRandom());
        pageToCreate.setCreatedAt(new Date());
        pageToCreate.setUpdatedAt(pageToCreate.getCreatedAt());
        pageToCreate.setName(this.documentationValidationDomainService.sanitizeDocumentationName(pageToCreate.getName()));
        if (pageToCreate.isMarkdown()) {
            this.documentationValidationDomainService.validateContentIsSafe(pageToCreate.getContent());
        }
        this.validateParentId(pageToCreate);
        this.validateNameIsUnique(pageToCreate);
        this.calculateOrder(pageToCreate);
        Page createdPage = this.createApiDocumentationDomainService.createPage(pageToCreate, input.auditInfo());
        if (createdPage.isHomepage()) {
            this.homepageDomainService.setPreviousHomepageToFalse(createdPage.getReferenceId(), createdPage.getId());
        }
        if (createdPage.isFolder()) {
            createdPage.setHidden(true);
        }
        return new Output(createdPage);
    }

    private void validateParentId(Page page) {
        Optional<Page> foundParent;
        String parentId = page.getParentId();
        if (Objects.nonNull(parentId) && !parentId.isEmpty() && (foundParent = this.pageCrudService.findById(parentId)).isPresent()) {
            if (!foundParent.get().isFolder()) {
                throw new InvalidPageParentException(parentId);
            }
            return;
        }
        page.setParentId(null);
    }

    private void validateNameIsUnique(Page page) {
        this.apiDocumentationDomainService.validateNameIsUnique(page.getReferenceId(), page.getParentId(), page.getName(), page.getType());
    }

    private void calculateOrder(Page page) {
        Optional<Page> lastPage = this.pageQueryService.searchByApiIdAndParentId(page.getReferenceId(), page.getParentId()).stream().max(Comparator.comparingInt(Page::getOrder));
        Integer nextOrder = lastPage.map(value -> value.getOrder() + 1).orElse(0);
        page.setOrder(nextOrder);
    }

    @Generated
    public ApiCreateDocumentationPageUseCase(CreateApiDocumentationDomainService createApiDocumentationDomainService, ApiDocumentationDomainService apiDocumentationDomainService, HomepageDomainService homepageDomainService, PageCrudService pageCrudService, PageQueryService pageQueryService, DocumentationValidationDomainService documentationValidationDomainService) {
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.homepageDomainService = homepageDomainService;
        this.pageCrudService = pageCrudService;
        this.pageQueryService = pageQueryService;
        this.documentationValidationDomainService = documentationValidationDomainService;
    }

    public record Input(Page page, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Page page;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder page(Page page) {
                this.page = page;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.page, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "ApiCreateDocumentationPageUseCase.Input.InputBuilder(page=" + this.page + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Page createdPage) {
    }
}

