/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.api.domain_service.ApiHostValidatorDomainService;
import io.gravitee.apim.core.api.domain_service.InvalidHostException;
import io.gravitee.apim.core.api.domain_service.PathAlreadyExistsException;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.installation.model.RestrictedDomain;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyApiPathDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyApiPathDomainService.class);
    private final ApiQueryService apiSearchService;
    private final InstallationAccessQueryService installationAccessQueryService;
    private final ApiHostValidatorDomainService apiHostValidatorDomainService;

    public VerifyApiPathDomainService(ApiQueryService apiSearchService, InstallationAccessQueryService installationAccessQueryService, ApiHostValidatorDomainService apiHostValidatorDomainService) {
        this.apiSearchService = apiSearchService;
        this.installationAccessQueryService = installationAccessQueryService;
        this.apiHostValidatorDomainService = apiHostValidatorDomainService;
    }

    public List<Path> checkAndSanitizeApiPaths(String environmentId, String apiId, List<Path> paths) {
        if (paths == null || paths.isEmpty()) {
            throw new InvalidPathsException("At least one path is required for the listener HTTP.");
        }
        try {
            List<Path> sanitizedPaths = paths.stream().map(path -> Path.builder().host(path.getHost()).path(path.getPath()).overrideAccess(path.isOverrideAccess()).build().sanitize()).toList();
            List<Path> pathsWithDomain = this.validateAndSetDomain(environmentId, sanitizedPaths);
            this.checkNoDuplicate(pathsWithDomain);
            this.checkPathsAreAvailable(environmentId, apiId, pathsWithDomain);
            return pathsWithDomain;
        }
        catch (InvalidHostException | PathAlreadyExistsException e) {
            throw new InvalidPathsException(e.getMessage(), e);
        }
    }

    private void checkNoDuplicate(List<Path> paths) throws PathAlreadyExistsException {
        HashSet set = new HashSet();
        List<Path> duplicates = paths.stream().filter(n -> !set.add(n)).toList();
        if (!duplicates.isEmpty()) {
            throw new PathAlreadyExistsException(duplicates.get(0).toString());
        }
    }

    private void checkPathsAreAvailable(String environmentId, String apiId, List<Path> paths) {
        this.apiSearchService.search(ApiSearchCriteria.builder().environmentId(environmentId).build(), null, ApiFieldFilter.builder().pictureExcluded(true).build()).filter(api -> !api.getId().equals(apiId)).map(this::extractPaths).filter(extractedPaths -> extractedPaths != null && !extractedPaths.isEmpty()).forEach(existingPaths -> {
            List registeredPathWithoutHost;
            Map registeredPathWithHosts = existingPaths.stream().filter(path -> path.getHost() != null && !path.getHost().isEmpty()).collect(Collectors.groupingBy(Path::getHost, Collectors.mapping(Path::getPath, Collectors.toList())));
            if (!registeredPathWithHosts.isEmpty()) {
                paths.stream().filter(path -> path.getHost() != null && !path.getHost().isEmpty()).forEach(path -> this.checkPathNotYetRegistered(path.getPath(), (List)registeredPathWithHosts.get(path.getHost())));
            }
            if (!(registeredPathWithoutHost = existingPaths.stream().filter(path -> path.getHost() == null || path.getHost().isEmpty()).map(Path::getPath).collect(Collectors.toList())).isEmpty()) {
                paths.stream().filter(path -> path.getHost() == null || path.getHost().isEmpty()).forEach(virtualHost -> this.checkPathNotYetRegistered(virtualHost.getPath(), registeredPathWithoutHost));
            }
        });
    }

    private List<Path> extractPaths(Api api) {
        if (api.getDefinitionVersion() != null && api.getDefinitionVersion() == DefinitionVersion.V4) {
            return api.getApiDefinitionV4().getListeners().stream().filter(HttpListener.class::isInstance).map(HttpListener.class::cast).flatMap(httpListener -> httpListener.getPaths().stream().map(path -> Path.builder().host(path.getHost()).path(path.getPath()).overrideAccess(path.isOverrideAccess()).build().sanitize())).collect(Collectors.toList());
        }
        return api.getApiDefinition().getProxy().getVirtualHosts().stream().map(virtualHost -> Path.builder().host(virtualHost.getHost()).path(virtualHost.getPath()).overrideAccess(virtualHost.isOverrideEntrypoint()).build().sanitize()).collect(Collectors.toList());
    }

    private void checkPathNotYetRegistered(String path, List<String> registeredPaths) {
        boolean match;
        boolean bl = match = registeredPaths != null && registeredPaths.stream().anyMatch(registeredPath -> path.startsWith((String)registeredPath) || registeredPath.startsWith(path));
        if (match) {
            throw new PathAlreadyExistsException(path);
        }
    }

    private List<Path> validateAndSetDomain(String environmentId, List<Path> sanitizedPaths) throws InvalidPathsException {
        List<RestrictedDomain> restrictedDomains = this.installationAccessQueryService.getGatewayRestrictedDomains(environmentId);
        if (restrictedDomains != null && !restrictedDomains.isEmpty()) {
            for (Path path : sanitizedPaths) {
                if (path.hasHost()) {
                    this.checkDomainIsValid(path, restrictedDomains);
                    continue;
                }
                path.setHost(restrictedDomains.get(0).getDomain());
            }
            if (!sanitizedPaths.isEmpty() && sanitizedPaths.stream().noneMatch(Path::isOverrideAccess)) {
                sanitizedPaths.get(0).setOverrideAccess(true);
            }
        }
        return sanitizedPaths;
    }

    private void checkDomainIsValid(Path path, List<RestrictedDomain> restrictedDomainEntities) {
        String hostWithoutPort = VerifyApiPathDomainService.extractHost(path.getHost());
        List<String> restrictedDomainsWithoutPort = restrictedDomainEntities.stream().map(restrictedDomainEntity -> VerifyApiPathDomainService.extractHost(restrictedDomainEntity.getDomain())).toList();
        String onlyPort = VerifyApiPathDomainService.extractPort(path.getHost());
        if (!this.apiHostValidatorDomainService.isValidDomainOrSubDomain(hostWithoutPort, restrictedDomainsWithoutPort) || !this.isValidPort(onlyPort, restrictedDomainEntities)) {
            throw new InvalidHostException("Host [" + hostWithoutPort + "] must be a subdomain of " + restrictedDomainEntities.stream().map(RestrictedDomain::getDomain).toList());
        }
    }

    private boolean isValidPort(String port, List<RestrictedDomain> restrictedDomainEntities) {
        if (restrictedDomainEntities.isEmpty()) {
            return true;
        }
        return restrictedDomainEntities.stream().anyMatch(restrictedDomainEntity -> {
            String domainRestriction = restrictedDomainEntity.getDomain();
            String domainRestrictionOnlyPort = VerifyApiPathDomainService.extractPort(domainRestriction);
            return port == null && domainRestrictionOnlyPort == null || port == null && VerifyApiPathDomainService.isDefaultHttp(domainRestrictionOnlyPort) || domainRestrictionOnlyPort == null && VerifyApiPathDomainService.isDefaultHttp(port) || Objects.equals(port, domainRestrictionOnlyPort);
        });
    }

    private static boolean isDefaultHttp(String domainRestrictionOnlyPort) {
        return "80".equals(domainRestrictionOnlyPort) || "443".equals(domainRestrictionOnlyPort);
    }

    private static String extractHost(String hostAndPort) {
        return hostAndPort.split(":")[0];
    }

    private static String extractPort(String hostAndPort) {
        String[] split = hostAndPort.split(":");
        if (split.length > 1) {
            return split[1];
        }
        return null;
    }
}

