/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class EmailNotification {
    private String from;
    private String fromName;
    private String[] to;
    private String[] bcc;
    private String template;
    private Map<String, Object> params = new HashMap<String, Object>();
    private boolean copyToSender;
    private String replyTo;

    public boolean hasRecipients() {
        return this.getTo() != null && this.getTo().length > 0 || this.getBcc() != null && this.getBcc().length > 0;
    }

    public Integer recipientsCount() {
        return (this.getTo() != null ? this.getTo().length : 0) + (this.getBcc() != null ? this.getBcc().length : 0);
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String ... to) {
        this.to = to;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setCopyToSender(boolean copyToSender) {
        this.copyToSender = copyToSender;
    }

    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailNotification)) {
            return false;
        }
        EmailNotification that = (EmailNotification)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.fromName, that.fromName) && Arrays.equals(this.to, that.to) && Objects.equals(this.template, that.template) && Objects.equals(this.params, that.params) && Arrays.equals(this.bcc, that.bcc) && Objects.equals(this.copyToSender, that.copyToSender) && Objects.equals(this.replyTo, that.replyTo);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.fromName, Arrays.hashCode(this.to), this.template, this.params, this.copyToSender, Arrays.hashCode(this.bcc), this.replyTo);
    }

    public String toString() {
        return "EmailNotification{from='" + this.from + "', reply-to='" + this.replyTo + "', fromName='" + this.fromName + "', to=" + Arrays.toString(this.to) + ", template='" + this.template + "', params=" + this.params + ", copyToSender=" + this.copyToSender + ", bcc=" + Arrays.toString(this.bcc) + "}";
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getFromName() {
        return this.fromName;
    }

    @Generated
    public String[] getTo() {
        return this.to;
    }

    @Generated
    public String[] getBcc() {
        return this.bcc;
    }

    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Generated
    public boolean isCopyToSender() {
        return this.copyToSender;
    }

    @Generated
    public String getReplyTo() {
        return this.replyTo;
    }
}

