/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ChannelSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.gravitee.rest.api.service.v4.exception.PathParameterOverlapValidationException;
import io.gravitee.rest.api.service.v4.validation.PathParametersValidationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class PathParametersValidationServiceImpl
implements PathParametersValidationService {
    private static final String PATH_PARAM_PREFIX = ":";
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern SEPARATOR_SPLITTER = Pattern.compile("/");
    private static final Pattern PARAM_PATTERN = Pattern.compile(":\\w*");
    private static final Map<ApiType, Function<Flow, Optional<String>>> PATH_EXTRACTOR = Map.of(ApiType.PROXY, flow -> flow.selectorByType(SelectorType.HTTP).stream().map(selector -> ((HttpSelector)selector).getPath()).findFirst(), ApiType.MESSAGE, flow -> flow.selectorByType(SelectorType.CHANNEL).stream().map(selector -> ((ChannelSelector)selector).getChannel()).findFirst());

    @Override
    public void validate(ApiType apiType, Stream<Flow> apiFlows, Stream<Flow> planFlows) {
        apiFlows = apiFlows == null ? Stream.empty() : apiFlows;
        planFlows = planFlows == null ? Stream.empty() : planFlows;
        Stream<Flow> flowsWithPathParam = this.filterFlowsWithPathParam(apiType, apiFlows, planFlows);
        this.validatePathParamOverlapping(apiType, flowsWithPathParam);
    }

    private Stream<Flow> filterFlowsWithPathParam(ApiType apiType, Stream<Flow> apiFlows, Stream<Flow> planFlows) {
        return Stream.concat(apiFlows, planFlows).filter(Flow::isEnabled).filter(flow -> PathParametersValidationServiceImpl.containsPathParam(apiType, flow));
    }

    private void validatePathParamOverlapping(ApiType apiType, Stream<Flow> flows) {
        HashMap paramWithPosition = new HashMap();
        HashMap pathsByParam = new HashMap();
        AtomicBoolean hasOverlap = new AtomicBoolean(false);
        flows.forEach(flow -> {
            String path = PathParametersValidationServiceImpl.extractPath(apiType, flow);
            String[] branches = SEPARATOR_SPLITTER.split(path);
            for (int i = 0; i < branches.length; ++i) {
                String currentBranch = branches[i];
                if (!currentBranch.startsWith(PATH_PARAM_PREFIX)) continue;
                PathParametersValidationServiceImpl.prepareOverlapsMap(pathsByParam, path, currentBranch);
                if (PathParametersValidationServiceImpl.isOverlapping(paramWithPosition, currentBranch, i)) {
                    hasOverlap.set(true);
                    continue;
                }
                paramWithPosition.put(currentBranch, i);
            }
        });
        if (hasOverlap.get()) {
            throw new PathParameterOverlapValidationException(pathsByParam.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toString())));
        }
    }

    private static void prepareOverlapsMap(Map<String, List<String>> pathsByParam, String path, String branches) {
        pathsByParam.compute(branches, (key, value) -> {
            if (value == null) {
                value = new ArrayList<String>();
            }
            if (!value.contains(path)) {
                value.add(path);
            }
            return value;
        });
    }

    private static boolean isOverlapping(Map<String, Integer> paramWithPosition, String param, Integer i) {
        return paramWithPosition.containsKey(param) && !paramWithPosition.get(param).equals(i);
    }

    private static Boolean containsPathParam(ApiType apiType, Flow flow) {
        String path = PathParametersValidationServiceImpl.extractPath(apiType, flow);
        return PARAM_PATTERN.asPredicate().test(path);
    }

    private static String extractPath(ApiType apiType, Flow flow) {
        return PATH_EXTRACTOR.get(apiType).apply(flow).orElse("");
    }
}

