/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.service.PageDuplicateService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.PageConverter;
import io.gravitee.rest.api.service.impl.PageServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class PageDuplicateServiceImpl
implements PageDuplicateService {
    private final PageService pageService;
    private final PageConverter pageConverter;

    public PageDuplicateServiceImpl(PageService pageService, PageConverter pageConverter) {
        this.pageService = pageService;
        this.pageConverter = pageConverter;
    }

    @Override
    public Map<String, String> duplicatePages(ExecutionContext executionContext, String sourceApiId, String duplicatedApiId, String userId) {
        List<PageEntity> pagesToDuplicate = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(sourceApiId).build(), true);
        PageServiceImpl.PageEntityTreeNode root = new PageServiceImpl.PageEntityTreeNode(new PageEntity()).appendListToTree(pagesToDuplicate);
        return this.duplicateChildrenPages(executionContext, userId, duplicatedApiId, null, root.children);
    }

    private Map<String, String> duplicateChildrenPages(ExecutionContext executionContext, String userId, String duplicateApiId, String parentId, List<PageServiceImpl.PageEntityTreeNode> children) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        for (PageServiceImpl.PageEntityTreeNode child : children) {
            String sourcePageId = child.data.getId();
            String newPageId = UuidString.generateForEnvironment(executionContext.getEnvironmentId(), duplicateApiId, sourcePageId);
            NewPageEntity newPageEntity = this.pageConverter.toNewPageEntity(child.data.toBuilder().lastContributor(userId).parentId(parentId).build(), true);
            PageEntity duplicatedPage = this.pageService.createPage(executionContext, duplicateApiId, newPageEntity, newPageId);
            idsMap.put(sourcePageId, duplicatedPage.getId());
            if (child.children == null || child.children.isEmpty()) continue;
            idsMap.putAll(this.duplicateChildrenPages(executionContext, userId, duplicateApiId, duplicatedPage.getId(), child.children));
        }
        return idsMap;
    }
}

