/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ScanResult;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.api.annotations.RequireResource;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.model.PolicyDevelopmentEntity;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.platform.plugin.SchemaDisplayFormat;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PolicyServiceImpl
extends AbstractPluginService<PolicyPlugin<?>, PolicyEntity>
implements PolicyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyServiceImpl.class);
    private final Map<String, PolicyDevelopmentEntity> policies = new ConcurrentHashMap<String, PolicyDevelopmentEntity>();
    private PolicyClassLoaderFactory policyClassLoaderFactory;

    public PolicyServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<PolicyPlugin<?>> pluginManager, PolicyClassLoaderFactory policyClassLoaderFactory) {
        super(jsonSchemaService, pluginManager);
        this.policyClassLoaderFactory = policyClassLoaderFactory;
    }

    @Override
    public Set<PolicyEntity> findAll(Boolean withResource) {
        Stream<Object> policies = super.list().stream();
        if (Boolean.FALSE.equals(withResource)) {
            policies = policies.filter(policyPlugin -> !policyPlugin.policy().isAnnotationPresent(RequireResource.class));
        }
        return policies.filter(policyPlugin -> StringUtils.isEmpty((CharSequence)((CharSequence)policyPlugin.manifest().properties().get("message"))) || StringUtils.isNotEmpty((CharSequence)((CharSequence)policyPlugin.manifest().properties().get("proxy")))).map(policyDefinition -> this.convert((PolicyPlugin)policyDefinition, true)).collect(Collectors.toSet());
    }

    @Override
    public Set<PolicyEntity> findAll() {
        return this.findAll(true);
    }

    @Override
    public PolicyEntity findById(String policyId) {
        PolicyPlugin policyDefinition = (PolicyPlugin)super.get(policyId);
        return this.convert(policyDefinition, true);
    }

    @Override
    public String validatePolicyConfiguration(String policyName, String configuration) {
        return this.validateConfiguration(policyName, configuration);
    }

    @Override
    public void validatePolicyConfiguration(Step step) {
        if (step != null) {
            step.setConfiguration(this.validatePolicyConfiguration(step.getPolicy(), step.getConfiguration()));
        }
    }

    @Override
    public void validatePolicyConfiguration(Policy policy) {
        if (policy != null) {
            policy.setConfiguration(this.validatePolicyConfiguration(policy.getName(), policy.getConfiguration()));
        }
    }

    @Override
    public String getSchema(String pluginId, SchemaDisplayFormat schemaDisplayFormat) {
        if (schemaDisplayFormat == SchemaDisplayFormat.GV_SCHEMA_FORM) {
            try {
                this.logger.debug("Find plugin schema for format {} by ID: {}", (Object)schemaDisplayFormat, (Object)pluginId);
                String schema = this.pluginManager.getSchema(pluginId, "display-gv-schema-form", true);
                if (schema != null) {
                    return schema;
                }
                this.logger.debug("No specific schema-form exists for this display format. Fall back on default schema-form.");
            }
            catch (IOException ioex) {
                this.logger.debug("Error while getting specific schema-form for this display format. Fall back on default schema-form.");
            }
        }
        return this.getSchema(pluginId);
    }

    private PolicyEntity convert(PolicyPlugin policyPlugin, Boolean withPlugin) {
        PolicyEntity entity = new PolicyEntity();
        entity.setId(policyPlugin.id());
        entity.setDescription(policyPlugin.manifest().description());
        entity.setName(policyPlugin.manifest().name());
        entity.setVersion(policyPlugin.manifest().version());
        entity.setCategory(policyPlugin.manifest().category());
        entity.setDeployed(policyPlugin.deployed());
        if (withPlugin.booleanValue()) {
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(policyPlugin.clazz());
            pluginEntity.setPath(policyPlugin.path().toString());
            pluginEntity.setType(policyPlugin.type().toLowerCase());
            pluginEntity.setDependencies(policyPlugin.dependencies());
            entity.setPlugin(pluginEntity);
            entity.setDevelopment(this.loadPolicy(policyPlugin));
        }
        return entity;
    }

    private PolicyDevelopmentEntity loadPolicy(final PolicyPlugin policy) {
        return this.policies.computeIfAbsent(policy.id(), new Function<String, PolicyDevelopmentEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PolicyDevelopmentEntity apply(String s) {
                PolicyDevelopmentEntity developmentEntity = new PolicyDevelopmentEntity();
                developmentEntity.setClassName(policy.policy().getName());
                if (io.gravitee.gateway.reactive.api.policy.Policy.class.isAssignableFrom(policy.policy())) {
                    developmentEntity.setOnRequestMethod("setOnRequestMethod");
                    developmentEntity.setOnResponseMethod("setOnResponseMethod");
                } else {
                    ScanResult scan = null;
                    PluginClassLoader policyClassLoader = null;
                    try {
                        policyClassLoader = PolicyServiceImpl.this.policyClassLoaderFactory.getOrCreateClassLoader(policy);
                        scan = new ClassGraph().enableMethodInfo().enableAnnotationInfo().acceptClasses(new String[]{policy.policy().getName()}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{policyClassLoader}).scan(1);
                        MethodInfoList methodInfo = scan.getClassInfo(policy.policy().getName()).getMethodInfo();
                        MethodInfoList filter = methodInfo.filter(methodInfo1 -> methodInfo1.hasAnnotation(OnRequest.class.getName()) || methodInfo1.hasAnnotation(OnRequestContent.class.getName()));
                        if (!filter.isEmpty()) {
                            developmentEntity.setOnRequestMethod(((MethodInfo)filter.get(0)).getName());
                        }
                        if (!(filter = methodInfo.filter(methodInfo12 -> methodInfo12.hasAnnotation(OnResponse.class.getName()) || methodInfo12.hasAnnotation(OnResponseContent.class.getName()))).isEmpty()) {
                            developmentEntity.setOnResponseMethod(((MethodInfo)filter.get(0)).getName());
                        }
                    }
                    catch (Throwable ex) {
                        PolicyServiceImpl.this.logger.error("An unexpected error occurs while loading policy", ex);
                        PolicyDevelopmentEntity policyDevelopmentEntity = null;
                        return policyDevelopmentEntity;
                    }
                    finally {
                        if (policyClassLoader != null) {
                            try {
                                policyClassLoader.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("An error has occurred while trying to close policy class loader", (Throwable)e);
                            }
                        }
                        if (scan != null) {
                            scan.close();
                        }
                    }
                }
                return developmentEntity;
            }
        });
    }
}

