/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.cockpit.services.V4ApiServiceCockpit;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.reactivex.rxjava3.core.Single;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class V4ApiServiceCockpitImpl
implements V4ApiServiceCockpit {
    public static final String NEW_API_ENTITY_NODE = "/newApiEntity";
    public static final String PLAN_ENTITIES_NODE = "/planEntities";
    public static final String METADATA_NODE = "/metadata";
    private final ApiService apiServiceV4;
    private final ApiStateService apiStateService;
    private final GraviteeMapper graviteeMapper;
    private final ObjectMapper mapper;

    public V4ApiServiceCockpitImpl(ApiService apiServiceV4, ApiStateService apiStateService) {
        this.apiServiceV4 = apiServiceV4;
        this.apiStateService = apiStateService;
        this.graviteeMapper = new GraviteeMapper();
        this.mapper = new ObjectMapper();
    }

    @Override
    public Single<ApiEntity> createPublishApi(String userId, String apiDefinition) throws JsonProcessingException {
        JsonNode node = this.mapper.readTree(apiDefinition);
        NewApiEntity newApiEntity = this.getNewApiEntity(node);
        UpdateApiEntity updateApiEntity = this.getUpdateApiEntity(node);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        return Single.just((Object)this.apiServiceV4.create(executionContext, newApiEntity, userId)).flatMap(apiEntity -> this.publishApi(executionContext, (ApiEntity)apiEntity, userId, updateApiEntity)).flatMap(apiEntity -> this.syncDeployment(executionContext, apiEntity.getId(), userId));
    }

    private NewApiEntity getNewApiEntity(JsonNode node) throws JsonProcessingException {
        String newApiEntityNode = this.mapper.writeValueAsString((Object)node.at(NEW_API_ENTITY_NODE));
        return (NewApiEntity)this.graviteeMapper.readValue(newApiEntityNode, NewApiEntity.class);
    }

    private UpdateApiEntity getUpdateApiEntity(JsonNode node) throws JsonProcessingException {
        String newApiEntityNode = this.mapper.writeValueAsString((Object)node.at(NEW_API_ENTITY_NODE));
        String planEntitiesNode = this.mapper.writeValueAsString((Object)node.at(PLAN_ENTITIES_NODE));
        String metaDataNode = this.mapper.writeValueAsString((Object)node.at(METADATA_NODE));
        UpdateApiEntity updateApiEntity = (UpdateApiEntity)this.graviteeMapper.readValue(newApiEntityNode, UpdateApiEntity.class);
        PlanEntity[] planEntities = (PlanEntity[])this.graviteeMapper.readValue(planEntitiesNode, PlanEntity[].class);
        ApiMetadataEntity[] apiMetadataEntities = (ApiMetadataEntity[])this.graviteeMapper.readValue(metaDataNode, ApiMetadataEntity[].class);
        updateApiEntity.setPlans(new HashSet<PlanEntity>(Arrays.asList(planEntities)));
        updateApiEntity.setMetadata(List.of(apiMetadataEntities));
        return updateApiEntity;
    }

    private Single<ApiEntity> syncDeployment(ExecutionContext executionContext, String apiId, String userId) {
        ApiDeploymentEntity deploymentEntity = new ApiDeploymentEntity();
        return Single.just((Object)((ApiEntity)this.apiStateService.deploy(executionContext, apiId, userId, deploymentEntity)));
    }

    private Single<ApiEntity> publishApi(ExecutionContext executionContext, ApiEntity apiEntity, String userId, UpdateApiEntity updateApiEntity) {
        UpdateApiEntity apiToUpdate = this.createUpdateApiEntity(apiEntity, updateApiEntity);
        ApiEntity update = this.apiServiceV4.update(executionContext, apiEntity.getId(), apiToUpdate, userId);
        return Single.just((Object)((ApiEntity)this.apiStateService.start(executionContext, update.getId(), userId)));
    }

    private UpdateApiEntity createUpdateApiEntity(ApiEntity apiEntity, UpdateApiEntity updateApiEntity) {
        UpdateApiEntity entity = new UpdateApiEntity();
        entity.setId(apiEntity.getId());
        entity.setName(apiEntity.getName());
        entity.setApiVersion(apiEntity.getApiVersion());
        entity.setDefinitionVersion(apiEntity.getDefinitionVersion());
        entity.setType(apiEntity.getType());
        entity.setDescription(apiEntity.getDescription());
        entity.setEndpointGroups(apiEntity.getEndpointGroups());
        entity.setAnalytics(apiEntity.getAnalytics());
        entity.setFlows(apiEntity.getFlows());
        entity.setFlowExecution(apiEntity.getFlowExecution());
        entity.setResponseTemplates(apiEntity.getResponseTemplates());
        entity.setServices(apiEntity.getServices());
        entity.setGroups(apiEntity.getGroups());
        entity.setVisibility(Visibility.PUBLIC);
        entity.setPicture(apiEntity.getPicture());
        entity.setPictureUrl(apiEntity.getPictureUrl());
        entity.setCategories(apiEntity.getCategories());
        entity.setLabels(apiEntity.getLabels());
        entity.setLifecycleState(ApiLifecycleState.PUBLISHED);
        entity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        entity.setBackground(apiEntity.getBackground());
        entity.setBackgroundUrl(apiEntity.getBackgroundUrl());
        entity.setMetadata(updateApiEntity.getMetadata());
        entity.setProperties(updateApiEntity.getProperties());
        entity.setResources(updateApiEntity.getResources());
        entity.setPlans(updateApiEntity.getPlans());
        entity.setListeners(updateApiEntity.getListeners());
        return entity;
    }
}

