/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.crud_service.application;

import io.gravitee.apim.crud_service.application.ApplicationCrudService;
import io.gravitee.apim.crud_service.application.adapter.ApplicationMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.Application;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCrudServiceImpl
implements ApplicationCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationCrudServiceImpl.class);
    private final ApplicationRepository applicationRepository;

    public ApplicationCrudServiceImpl(@Lazy ApplicationRepository applicationRepository) {
        this.applicationRepository = applicationRepository;
    }

    @Override
    public BaseApplicationEntity findById(ExecutionContext executionContext, String applicationId) {
        try {
            log.debug("Find application by id: {}", (Object)applicationId);
            Optional<Application> applicationOptional = this.applicationRepository.findById((Object)applicationId);
            if (executionContext.hasEnvironmentId()) {
                applicationOptional = applicationOptional.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            if (applicationOptional.isPresent()) {
                return ApplicationMapper.mapToBaseApplication(applicationOptional.get());
            }
            throw new ApplicationNotFoundException(applicationId);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an application using its ID {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an application using its ID " + applicationId, ex);
        }
    }
}

