/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class TagNotFoundException
extends AbstractNotFoundException {
    private final String tags;

    public TagNotFoundException(String tag) {
        this.tags = "[ " + tag + "]";
    }

    public TagNotFoundException(String[] tags) {
        this.tags = Arrays.toString(tags);
    }

    @Override
    public String getMessage() {
        return "Tag(s) " + this.tags + " cannot be found.";
    }

    @Override
    public String getTechnicalCode() {
        return "tag.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("tag", this.tags);
    }
}

