/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Plan;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlansDataFixUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlansDataFixUpgrader.class);
    private static final String PLAN_DESCRIPTION = "This plan has been recreated during a data fix process. See documentation : https://docs.gravitee.io/apim/3.x/apim_installguide_migration.html#upgrade_to_3_10_8";
    private static final String PLAN_NAME_SUFFIX = "-Recreated";
    private final Map<String, ExecutionContext> executionContextByEnvironment = new ConcurrentHashMap<String, ExecutionContext>();
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;
    @Autowired
    private EmailService emailService;
    @Autowired
    private PrimaryOwnerService primaryOwnerService;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${services.plans-data-fix-upgrader.enabled:true}")
    private boolean enabled;
    @Value(value="${services.plans-data-fix-upgrader.notifyApiOwner:false}")
    private boolean notifyApiOwner;
    private boolean anomalyFound = false;

    public int getOrder() {
        return 500;
    }

    public boolean upgrade() {
        if (!this.enabled) {
            log.info("Skipping {} execution cause it's not enabled in configuration", (Object)this.getClass().getSimpleName());
            return true;
        }
        try {
            AtomicBoolean upgradeFailed = new AtomicBoolean(false);
            this.apiRepository.search(new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V2)).build(), null, ApiFieldFilter.allFields()).forEach(api -> {
                try {
                    io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                    ExecutionContext executionContext = this.getApiExecutionContext((Api)api);
                    if (executionContext != null) {
                        this.fixApiPlans(executionContext, (Api)api, apiDefinition);
                    }
                }
                catch (Exception e) {
                    upgradeFailed.set(true);
                    throw new RuntimeException(e);
                }
            });
            if (!this.anomalyFound) {
                log.info("No plan data anomaly found");
            }
            return !upgradeFailed.get();
        }
        catch (Exception e) {
            log.error("error applying upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    protected void fixApiPlans(ExecutionContext executionContext, Api api, io.gravitee.definition.model.Api apiDefinition) throws Exception {
        List definitionPlans;
        Set apiPlans = this.planRepository.findByApi(api.getId());
        if (!this.hasPlansDataAnomaly(apiPlans, definitionPlans = apiDefinition.getPlans())) {
            log.debug("Skipping API {} : no plans anomaly detected", (Object)api.getId());
            return;
        }
        if (!this.anomalyFound) {
            this.logWarningHeaderBlock();
            this.anomalyFound = true;
        }
        log.info("Plans anomalies found for API \"{}\" ({}) :", (Object)api.getName(), (Object)api.getId());
        Map<String, io.gravitee.repository.management.model.Plan> apiPlansMap = apiPlans.stream().collect(Collectors.toMap(io.gravitee.repository.management.model.Plan::getId, plan -> plan));
        Map<String, Plan> definitionPlansMap = definitionPlans.stream().collect(Collectors.toMap(Plan::getId, plan -> plan, (plan1, plan2) -> plan1));
        List<io.gravitee.repository.management.model.Plan> closedPlans = this.closeExtraApiPlans(definitionPlansMap, apiPlansMap);
        List<io.gravitee.repository.management.model.Plan> createdPlans = this.createMissingApiPlans(definitionPlansMap, apiPlansMap, api);
        this.updateApiDefinitionPlans(api, apiDefinition, definitionPlansMap);
        if (this.notifyApiOwner) {
            this.sendEmailToApiOwner(executionContext, api, createdPlans, closedPlans);
        }
    }

    protected List<io.gravitee.repository.management.model.Plan> createMissingApiPlans(Map<String, Plan> definitionPlansMap, Map<String, io.gravitee.repository.management.model.Plan> apiPlansMap, Api api) throws TechnicalException {
        ArrayList<io.gravitee.repository.management.model.Plan> addedPlans = new ArrayList<io.gravitee.repository.management.model.Plan>();
        for (Map.Entry<String, Plan> definitionPlanEntry : definitionPlansMap.entrySet()) {
            String planId = definitionPlanEntry.getKey();
            if (apiPlansMap.containsKey(planId)) continue;
            Plan definitionPlan = definitionPlanEntry.getValue();
            io.gravitee.repository.management.model.Plan newApiPlan = this.planFromDefinitionPlan(definitionPlan, api.getId());
            log.info("- Will create plan \"{}\" for API \"{}\" ({}), which is missing in plans table", new Object[]{newApiPlan.getName(), api.getName(), api.getId()});
            this.planRepository.create((Object)newApiPlan);
            apiPlansMap.put(planId, newApiPlan);
            definitionPlan.setId(newApiPlan.getId());
            definitionPlan.setName(newApiPlan.getName());
            addedPlans.add(newApiPlan);
        }
        return addedPlans;
    }

    protected List<io.gravitee.repository.management.model.Plan> closeExtraApiPlans(Map<String, Plan> definitionPlansMap, Map<String, io.gravitee.repository.management.model.Plan> apiPlansMap) throws TechnicalException {
        List<io.gravitee.repository.management.model.Plan> extraPlans = apiPlansMap.values().stream().filter(apiPlan -> apiPlan.getStatus() != Plan.Status.CLOSED).filter(apiPlan -> !definitionPlansMap.containsKey(apiPlan.getId())).collect(Collectors.toList());
        for (io.gravitee.repository.management.model.Plan plan : extraPlans) {
            log.info("- Will close plan \"{}\" ({}), cause it's absent from api definition", (Object)plan.getName(), (Object)plan.getId());
            plan.setStatus(Plan.Status.CLOSED);
            this.planRepository.update((Object)plan);
        }
        return extraPlans;
    }

    private io.gravitee.repository.management.model.Plan planFromDefinitionPlan(Plan definitionPlan, String apiId) {
        io.gravitee.repository.management.model.Plan plan = new io.gravitee.repository.management.model.Plan();
        plan.setId(UuidString.generateRandom());
        plan.setType(Plan.PlanType.API);
        plan.setValidation(Plan.PlanValidationType.MANUAL);
        plan.setStatus(Plan.Status.DEPRECATED);
        plan.setName(definitionPlan.getName().concat(PLAN_NAME_SUFFIX));
        plan.setDescription(PLAN_DESCRIPTION);
        plan.setApi(apiId);
        plan.setSecurityDefinition(definitionPlan.getSecurityDefinition());
        plan.setSelectionRule(definitionPlan.getSelectionRule());
        plan.setTags(definitionPlan.getTags());
        plan.setCreatedAt(new Date());
        plan.setUpdatedAt(plan.getCreatedAt());
        plan.setNeedRedeployAt(plan.getCreatedAt());
        if (definitionPlan.getSecurity() != null) {
            plan.setSecurity(Plan.PlanSecurityType.valueOf((String)definitionPlan.getSecurity()));
        }
        return plan;
    }

    private void updateApiDefinitionPlans(Api api, io.gravitee.definition.model.Api apiDefinition, Map<String, Plan> definitionPlansMap) throws TechnicalException, JsonProcessingException {
        apiDefinition.setPlans(new ArrayList<Plan>(definitionPlansMap.values()));
        api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
        this.apiRepository.update((Object)api);
    }

    private boolean hasPlansDataAnomaly(Set<io.gravitee.repository.management.model.Plan> apiPlans, List<Plan> definitionPlans) {
        List<String> apiPlansIds = apiPlans.stream().filter(plan -> plan.getStatus() != Plan.Status.CLOSED).map(io.gravitee.repository.management.model.Plan::getId).toList();
        List<String> definitionPlansIds = definitionPlans.stream().map(Plan::getId).toList();
        return apiPlansIds.size() != definitionPlansIds.size() || !definitionPlansIds.containsAll(apiPlansIds);
    }

    protected void sendEmailToApiOwner(ExecutionContext executionContext, Api api, List<io.gravitee.repository.management.model.Plan> createdPlans, List<io.gravitee.repository.management.model.Plan> closedPlans) {
        this.getApiOwnerEmail(executionContext, api).ifPresent(apiOwnerEmail -> {
            log.debug("Sending report email to api {} owner", (Object)api.getId());
            this.emailService.sendAsyncEmailNotification(executionContext, new EmailNotificationBuilder().params(Map.of("api", api, "closedPlans", closedPlans, "createdPlans", createdPlans)).to((String)apiOwnerEmail).template(EmailNotificationBuilder.EmailTemplate.API_PLANS_DATA_FIXED).build());
        });
    }

    private Optional<String> getApiOwnerEmail(ExecutionContext executionContext, Api api) {
        return Optional.ofNullable(this.primaryOwnerService.getPrimaryOwner(executionContext, api.getId()).getEmail());
    }

    private void logWarningHeaderBlock() {
        log.warn("");
        log.warn("##############################################################");
        log.warn("#                           WARNING                          #");
        log.warn("##############################################################");
        log.warn("");
        log.warn("We detected database anomalies in your plans data.");
        log.warn("");
        log.warn("Database anomalies will be fixed.");
        log.warn("See related documentation : https://docs.gravitee.io/apim/3.x/apim_installguide_migration.html#upgrade_to_3_10_8");
        log.warn("");
        log.warn("##############################################################");
        log.warn("");
    }

    private ExecutionContext getApiExecutionContext(Api api) {
        return this.executionContextByEnvironment.computeIfAbsent(api.getEnvironmentId(), envId -> {
            try {
                return this.environmentRepository.findById((Object)api.getEnvironmentId()).map(ExecutionContext::new).orElse(null);
            }
            catch (TechnicalException e) {
                log.error("failed to find environment {}", (Object)api.getEnvironmentId(), (Object)e);
                return null;
            }
        });
    }
}

