/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.spring;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.event.impl.EventManagerImpl;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.gateway.reactive.api.helper.PluginConfigurationHelper;
import io.gravitee.json.validation.JsonSchemaValidator;
import io.gravitee.json.validation.JsonSchemaValidatorImpl;
import io.gravitee.node.services.initializer.spring.InitializerConfiguration;
import io.gravitee.node.services.upgrader.spring.UpgraderConfiguration;
import io.gravitee.plugin.alert.spring.AlertPluginConfiguration;
import io.gravitee.plugin.apiservice.spring.ApiServicePluginConfiguration;
import io.gravitee.plugin.connector.spring.ConnectorPluginConfiguration;
import io.gravitee.plugin.discovery.spring.ServiceDiscoveryPluginConfiguration;
import io.gravitee.plugin.endpoint.spring.EndpointConnectorPluginConfiguration;
import io.gravitee.plugin.entrypoint.spring.EntrypointConnectorPluginConfiguration;
import io.gravitee.plugin.fetcher.spring.FetcherPluginConfiguration;
import io.gravitee.plugin.notifier.spring.NotifierPluginConfiguration;
import io.gravitee.plugin.policy.spring.PolicyPluginConfiguration;
import io.gravitee.plugin.resource.spring.ResourcePluginConfiguration;
import io.gravitee.repository.management.model.flow.FlowStep;
import io.gravitee.rest.api.fetcher.spring.FetcherConfigurationConfiguration;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.PasswordValidator;
import io.gravitee.rest.api.service.impl.search.configuration.SearchEngineConfiguration;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.impl.swagger.policy.impl.PolicyOperationVisitorManagerImpl;
import io.gravitee.rest.api.service.jackson.filter.ApiPermissionFilter;
import io.gravitee.rest.api.service.jackson.ser.FlowStepSerializer;
import io.gravitee.rest.api.service.jackson.ser.api.ApiCompositeSerializer;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.quality.ApiQualityMetricLoader;
import io.gravitee.rest.api.service.validator.RegexPasswordValidator;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(value={"io.gravitee.rest.api.service"})
@EnableTransactionManagement
@Import(value={PolicyPluginConfiguration.class, ResourcePluginConfiguration.class, FetcherPluginConfiguration.class, FetcherConfigurationConfiguration.class, SearchEngineConfiguration.class, NotifierPluginConfiguration.class, AlertPluginConfiguration.class, ServiceDiscoveryPluginConfiguration.class, ConnectorPluginConfiguration.class, EndpointConnectorPluginConfiguration.class, EntrypointConnectorPluginConfiguration.class, UpgraderConfiguration.class, InitializerConfiguration.class, ApiServicePluginConfiguration.class})
public class ServiceConfiguration {
    @Autowired
    private Environment environment;

    @Bean
    public EventManager eventManager() {
        return new EventManagerImpl();
    }

    @Bean
    public ObjectMapper objectMapper() {
        GraviteeMapper objectMapper = new GraviteeMapper(false);
        ApiPermissionFilter apiMembershipTypeFilter = new ApiPermissionFilter();
        objectMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider(Collections.singletonMap("apiMembershipTypeFilter", apiMembershipTypeFilter)));
        objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        SimpleModule module = new SimpleModule();
        module.addSerializer(ApiEntity.class, (JsonSerializer)this.apiSerializer());
        module.addSerializer(FlowStep.class, (JsonSerializer)new FlowStepSerializer(FlowStep.class));
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    @Bean
    public PluginConfigurationHelper pluginConfigurationHelper(io.gravitee.node.api.configuration.Configuration configuration, ObjectMapper objectMapper) {
        return new PluginConfigurationHelper(configuration, objectMapper);
    }

    @Bean
    public ApiQualityMetricLoader apiQualityMetricLoader() {
        return new ApiQualityMetricLoader();
    }

    @Bean
    public ApiSerializer apiSerializer() {
        return new ApiCompositeSerializer();
    }

    @Bean
    public PolicyOperationVisitorManager policyVisitorManager() {
        return new PolicyOperationVisitorManagerImpl();
    }

    @Bean
    public PasswordValidator passwordValidator() {
        return new RegexPasswordValidator();
    }

    @Bean
    public DataEncryptor apiPropertiesEncryptor() {
        return new DataEncryptor(this.environment, "api.properties.encryption.secret", "vvLJ4Q8Khvv9tm2tIPdkGEdmgKUruAL6");
    }

    @Bean
    public JsonSchemaValidator jsonSchemaValidator() {
        return new JsonSchemaValidatorImpl();
    }

    @Bean(name={"indexerThreadPoolTaskExecutor"})
    public Executor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("gio.search-indexer-");
        executor.setDaemon(true);
        executor.setCorePoolSize(2);
        return executor;
    }
}

