/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.rest.api.model.platform.plugin.SchemaDisplayFormat;
import io.gravitee.rest.api.model.v4.policy.ExecutionPhase;
import io.gravitee.rest.api.model.v4.policy.PolicyPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.v4.PolicyPluginService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PolicyPluginServiceImpl
extends AbstractPluginService<PolicyPlugin<?>, PolicyPluginEntity>
implements PolicyPluginService {
    protected PolicyPluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<PolicyPlugin<?>> policyManager) {
        super(jsonSchemaService, policyManager);
    }

    @Override
    public Set<PolicyPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public PolicyPluginEntity findById(String policyPluginId) {
        PolicyPlugin resourceDefinition = (PolicyPlugin)super.get(policyPluginId);
        return this.convert((Plugin)resourceDefinition);
    }

    protected PolicyPluginEntity convert(Plugin plugin) {
        PolicyPluginEntity entity = new PolicyPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setIcon(this.getIcon(plugin.id()));
        entity.setVersion(plugin.manifest().version());
        entity.setCategory(plugin.manifest().category());
        entity.setDeployed(plugin.deployed());
        entity.setProxy(PolicyPluginServiceImpl.getExecutionPhase(plugin, "proxy"));
        entity.setMessage(PolicyPluginServiceImpl.getExecutionPhase(plugin, "message"));
        return entity;
    }

    private static Set<ExecutionPhase> getExecutionPhase(Plugin plugin, String property) {
        if (plugin.manifest().properties() != null && plugin.manifest().properties().get(property) != null && !((String)plugin.manifest().properties().get(property)).isEmpty()) {
            return Arrays.stream(((String)plugin.manifest().properties().get(property)).split(",")).map(String::trim).map(ExecutionPhase::valueOf).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public String validatePolicyConfiguration(String policyPluginId, String configuration) {
        PolicyPluginEntity policyPluginEntity = this.findById(policyPluginId);
        return this.validateConfiguration(policyPluginEntity.getId(), configuration);
    }

    @Override
    public String validatePolicyConfiguration(PolicyPluginEntity policyPluginEntity, String configuration) {
        return this.validateConfiguration(policyPluginEntity.getId(), configuration);
    }

    @Override
    public String getSchema(String policyPluginId, SchemaDisplayFormat schemaDisplayFormat) {
        if (schemaDisplayFormat == SchemaDisplayFormat.GV_SCHEMA_FORM) {
            try {
                this.logger.debug("Find plugin schema for format {} by ID: {}", (Object)schemaDisplayFormat, (Object)policyPluginId);
                String schema = this.pluginManager.getSchema(policyPluginId, "display-gv-schema-form", true);
                if (schema != null) {
                    return schema;
                }
                this.logger.debug("No specific schema-form exists for this display format. Fall back on default schema-form.");
            }
            catch (IOException ioex) {
                this.logger.debug("Error while getting specific specific schema-form for this display format. Fall back on default schema-form.");
            }
        }
        return this.getSchema(policyPluginId);
    }
}

