/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanQuery;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.mapper.GenericPlanMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="PlanSearchServiceImplV4")
public class PlanSearchServiceImpl
extends TransactionalService
implements PlanSearchService {
    private final Logger logger = LoggerFactory.getLogger(PlanSearchServiceImpl.class);
    private final PlanRepository planRepository;
    private final ApiRepository apiRepository;
    private final GroupService groupService;
    private final ApiSearchService apiSearchService;
    private final ObjectMapper objectMapper;
    private final GenericPlanMapper genericPlanMapper;

    public PlanSearchServiceImpl(@Lazy PlanRepository planRepository, @Lazy ApiRepository apiRepository, @Lazy GroupService groupService, @Lazy ApiSearchService apiSearchService, ObjectMapper objectMapper, GenericPlanMapper genericPlanMapper) {
        this.planRepository = planRepository;
        this.apiRepository = apiRepository;
        this.groupService = groupService;
        this.apiSearchService = apiSearchService;
        this.objectMapper = objectMapper;
        this.genericPlanMapper = genericPlanMapper;
    }

    @Override
    public GenericPlanEntity findById(ExecutionContext executionContext, String plan) {
        try {
            this.logger.debug("Find plan by id : {}", (Object)plan);
            return this.planRepository.findById((Object)plan).map(this::mapToGeneric).orElseThrow(() -> new PlanNotFoundException(plan));
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by id: %s", plan), ex);
        }
    }

    @Override
    public Set<GenericPlanEntity> findByIdIn(ExecutionContext executionContext, Set<String> ids) {
        try {
            return this.planRepository.findByIdIn(ids).stream().map(this::mapToGeneric).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred retrieving plans by ids", e);
        }
    }

    @Override
    public Set<GenericPlanEntity> findByApi(ExecutionContext executionContext, String apiId) {
        try {
            this.logger.debug("Find plan by api : {}", (Object)apiId);
            Optional apiOptional = this.apiRepository.findById((Object)apiId);
            if (apiOptional.isPresent()) {
                Api api = (Api)apiOptional.get();
                return this.planRepository.findByApi(apiId).stream().map(plan -> this.genericPlanMapper.toGenericPlan(api, (Plan)plan)).collect(Collectors.toSet());
            }
            return Set.of();
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by api: %s", apiId), ex);
        }
    }

    @Override
    public List<GenericPlanEntity> search(ExecutionContext executionContext, PlanQuery query, String user, boolean isAdmin) {
        if (query.getApiId() == null) {
            return Collections.emptyList();
        }
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, query.getApiId());
        return this.findByApi(executionContext, query.getApiId()).stream().filter(p -> {
            boolean filtered = true;
            if (query.getName() != null) {
                filtered = query.getName().equals(p.getName());
            }
            if (filtered && !CollectionUtils.isEmpty((Collection)query.getSecurityType())) {
                if (p.getPlanSecurity() == null || p.getPlanSecurity().getType() == null) {
                    return false;
                }
                PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)p.getPlanSecurity().getType());
                filtered = query.getSecurityType().contains(planSecurityType);
            }
            if (filtered && !CollectionUtils.isEmpty((Collection)query.getStatus())) {
                PlanStatus planStatus = PlanStatus.valueOfLabel((String)p.getPlanStatus().getLabel());
                filtered = query.getStatus().contains(planStatus);
            }
            if (filtered && query.getMode() != null) {
                filtered = query.getMode().equals((Object)p.getPlanMode());
            }
            return filtered;
        }).filter(plan -> isAdmin || this.groupService.isUserAuthorizedToAccessApiData(genericApiEntity, plan.getExcludedGroups(), user)).collect(Collectors.toList());
    }

    @Override
    public boolean anyPlanMismatchWithApi(List<String> planIds, String apiId) {
        try {
            return this.planRepository.findByIdIn(planIds).stream().map(Plan::getApi).filter(Objects::nonNull).anyMatch(id -> !id.equals(apiId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred checking plans ownership", e);
        }
    }

    @Override
    public Map<String, Object> findByIdAsMap(String id) throws TechnicalException {
        Plan plan = (Plan)this.planRepository.findById((Object)id).orElseThrow(() -> new PlanNotFoundException(id));
        return (Map)this.objectMapper.convertValue((Object)plan, Map.class);
    }

    private GenericPlanEntity mapToGeneric(Plan plan) {
        try {
            Optional apiOptional = this.apiRepository.findById((Object)plan.getApi());
            Api api = (Api)apiOptional.orElseThrow(() -> new ApiNotFoundException(plan.getApi()));
            return this.genericPlanMapper.toGenericPlan(api, plan);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + plan.getApi(), e);
        }
    }
}

