/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.v4.ApiIdsCalculatorService;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.PlanService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ApiIdsCalculatorServiceImplV4")
public class ApiIdsCalculatorServiceImpl
implements ApiIdsCalculatorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiIdsCalculatorServiceImpl.class);
    private ApiService apiService;
    private PageService pageService;
    private PlanService planService;

    @Override
    public ExportApiEntity recalculateApiDefinitionIds(ExecutionContext executionContext, ExportApiEntity toRecalculate) {
        Objects.requireNonNull(toRecalculate.getApiEntity(), "ApiEntity is mandatory");
        if (toRecalculate.getApiEntity().getId() == null || toRecalculate.getApiEntity().getId().isEmpty()) {
            this.findApiByEnvironmentAndCrossId(executionContext.getEnvironmentId(), toRecalculate.getApiEntity().getCrossId()).ifPresentOrElse(api -> this.recalculateIdsFromCrossId(executionContext, toRecalculate, (ApiEntity)api), () -> this.recalculateIdsFromDefinitionIds(executionContext, toRecalculate));
        }
        return this.generateEmptyIdsForPlansAndPages(toRecalculate);
    }

    private void recalculateIdsFromCrossId(ExecutionContext executionContext, ExportApiEntity toRecalculate, ApiEntity api) {
        log.debug("Recalculating page and plans ids from cross id {} for api {}", (Object)api.getCrossId(), (Object)api.getId());
        toRecalculate.getApiEntity().setId(api.getId());
        Map<String, String> newPageIdsByOldPageIds = this.recalculatePageIdsFromCrossIds(executionContext.getEnvironmentId(), api, toRecalculate.getPages());
        this.recalculatePlanIdsFromCrossIds(executionContext, api, toRecalculate.getPlans(), newPageIdsByOldPageIds);
    }

    private Map<String, String> recalculatePageIdsFromCrossIds(String environmentId, ApiEntity api, List<PageEntity> pagesToRecalculate) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        Map pagesByCrossId = this.pageService.findByApi(environmentId, api.getId()).stream().filter(page -> page.getCrossId() != null).collect(Collectors.toMap(PageEntity::getCrossId, Function.identity()));
        pagesToRecalculate.stream().filter(page -> page.getCrossId() != null && !page.getCrossId().isEmpty()).forEach(page -> {
            String pageId = page.getId() != null && !page.getId().isEmpty() ? page.getId() : null;
            PageEntity matchingPage = (PageEntity)pagesByCrossId.get(page.getCrossId());
            String newPageId = matchingPage != null ? matchingPage.getId() : UuidString.generateRandom();
            page.setId(newPageId);
            idsMap.put(pageId, newPageId);
            this.updatePagesHierarchy(pagesToRecalculate, pageId, newPageId);
        });
        return idsMap;
    }

    private void recalculatePlanIdsFromCrossIds(ExecutionContext executionContext, ApiEntity api, Set<PlanEntity> plansToRecalculate, Map<String, String> newPageIdsByOldPageIds) {
        Map plansByCrossId = this.planService.findByApi(executionContext, api.getId()).stream().filter(plan -> plan.getCrossId() != null).collect(Collectors.toMap(PlanEntity::getCrossId, Function.identity()));
        plansToRecalculate.stream().map(plan -> ApiIdsCalculatorServiceImpl.recalculateGeneralConditionsPageId(plan, newPageIdsByOldPageIds)).filter(plan -> plan.getCrossId() != null && !plan.getCrossId().isEmpty()).forEach(plan -> {
            PlanEntity matchingPlan = (PlanEntity)plansByCrossId.get(plan.getCrossId());
            plan.setId(matchingPlan != null ? matchingPlan.getId() : UuidString.generateRandom());
        });
    }

    private void updatePagesHierarchy(List<PageEntity> pages, String parentId, String newParentId) {
        pages.stream().filter(page -> this.isChildPageOf((PageEntity)page, parentId)).forEach(child -> child.setParentId(newParentId));
    }

    private boolean isChildPageOf(PageEntity page, String parentPageId) {
        return page.getParentId() != null && !page.getParentId().isEmpty() && page.getParentId().equals(parentPageId);
    }

    private void recalculateIdsFromDefinitionIds(ExecutionContext executionContext, ExportApiEntity toRecalculate) {
        if (this.canRecalculateIds(toRecalculate)) {
            log.debug("Recalculating page and plans ids from definition");
            String newApiId = UuidString.generateForEnvironment(executionContext.getEnvironmentId(), toRecalculate.getApiEntity().getId());
            toRecalculate.getApiEntity().setId(newApiId);
            Map<String, String> pagesIdsMap = this.recalculatePageIdsFromDefinitionIds(toRecalculate.getPages(), executionContext.getEnvironmentId(), newApiId);
            this.recalculatePlanIdsFromDefinitionIds(toRecalculate.getPlans(), executionContext.getEnvironmentId(), newApiId, pagesIdsMap);
        }
    }

    private Map<String, String> recalculatePageIdsFromDefinitionIds(List<PageEntity> pages, String environmentId, String apiId) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        pages.stream().filter(page -> page.getId() != null && !page.getId().isEmpty()).forEach(page -> {
            String oldPageId = page.getId();
            String newPageId = UuidString.generateForEnvironment(environmentId, apiId, oldPageId);
            page.setId(newPageId);
            idsMap.put(oldPageId, newPageId);
            this.updatePagesHierarchy(pages, oldPageId, newPageId);
        });
        return idsMap;
    }

    private void recalculatePlanIdsFromDefinitionIds(Set<PlanEntity> plans, String environmentId, String apiId, Map<String, String> pagesIdsMap) {
        plans.stream().map(plan -> ApiIdsCalculatorServiceImpl.recalculateGeneralConditionsPageId(plan, pagesIdsMap)).filter(plan -> plan.getId() != null && !plan.getId().isEmpty()).forEach(plan -> plan.setId(UuidString.generateForEnvironment(environmentId, apiId, plan.getId())));
    }

    private Optional<ApiEntity> findApiByEnvironmentAndCrossId(String environmentId, String apiCrossId) {
        return apiCrossId == null ? Optional.empty() : this.apiService.findByEnvironmentIdAndCrossId(environmentId, apiCrossId);
    }

    private static PlanEntity recalculateGeneralConditionsPageId(PlanEntity plan, Map<String, String> newPageIdsByOldPageIds) {
        if (plan.getGeneralConditions() != null && !plan.getGeneralConditions().isEmpty()) {
            plan.setGeneralConditions(newPageIdsByOldPageIds.get(plan.getGeneralConditions()));
        }
        return plan;
    }

    private boolean canRecalculateIds(ExportApiEntity api) {
        DefinitionContext definitionContext = api.getApiEntity().getDefinitionContext();
        return !"kubernetes".equalsIgnoreCase(definitionContext != null ? definitionContext.getOrigin() : null);
    }

    private ExportApiEntity generateEmptyIdsForPlansAndPages(ExportApiEntity toRecalculate) {
        Stream.concat(toRecalculate.getPlans() != null ? toRecalculate.getPlans().stream() : Stream.empty(), toRecalculate.getPages() != null ? toRecalculate.getPages().stream() : Stream.empty()).filter(identifiable -> identifiable.getId() == null || identifiable.getId().isEmpty()).forEach(identifiable -> identifiable.setId(UuidString.generateRandom()));
        return toRecalculate;
    }

    @Generated
    public ApiIdsCalculatorServiceImpl(ApiService apiService, PageService pageService, PlanService planService) {
        this.apiService = apiService;
        this.pageService = pageService;
        this.planService = planService;
    }
}

