/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import io.gravitee.common.util.Maps;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMetadataEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class UserConverter {
    public User toUser(NewExternalUserEntity newExternalUserEntity) {
        if (newExternalUserEntity == null) {
            return null;
        }
        User user = new User();
        user.setEmail(newExternalUserEntity.getEmail());
        user.setFirstname(newExternalUserEntity.getFirstname());
        user.setLastname(newExternalUserEntity.getLastname());
        user.setSource(newExternalUserEntity.getSource());
        user.setSourceId(newExternalUserEntity.getSourceId());
        user.setStatus(UserStatus.ACTIVE);
        user.setPicture(newExternalUserEntity.getPicture());
        user.setNewsletterSubscribed(newExternalUserEntity.getNewsletter());
        return user;
    }

    public User toUser(UserEntity userEntity) {
        if (userEntity == null) {
            return null;
        }
        User user = new User();
        user.setId(userEntity.getId());
        user.setEmail(userEntity.getEmail());
        user.setFirstname(userEntity.getFirstname());
        user.setLastname(userEntity.getLastname());
        user.setSource(userEntity.getSource());
        user.setSourceId(userEntity.getSourceId());
        if (userEntity.getStatus() != null) {
            user.setStatus(UserStatus.valueOf((String)userEntity.getStatus()));
        }
        return user;
    }

    public UserEntity toUserEntity(User user) {
        return this.toUserEntity(user, null);
    }

    public UserEntity toUserEntity(User user, List<UserMetadataEntity> customUserFields) {
        if (user == null) {
            return null;
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setId(user.getId());
        userEntity.setOrganizationId(user.getOrganizationId());
        userEntity.setSource(user.getSource());
        userEntity.setSourceId(user.getSourceId());
        userEntity.setEmail(user.getEmail());
        userEntity.setFirstname(user.getFirstname());
        userEntity.setLastname(user.getLastname());
        userEntity.setPassword(user.getPassword());
        userEntity.setCreatedAt(user.getCreatedAt());
        userEntity.setUpdatedAt(user.getUpdatedAt());
        userEntity.setLastConnectionAt(user.getLastConnectionAt());
        userEntity.setFirstConnectionAt(user.getFirstConnectionAt());
        userEntity.setPicture(user.getPicture());
        userEntity.setReferenceType(GraviteeContext.ReferenceContextType.ORGANIZATION.name());
        userEntity.setReferenceId(user.getOrganizationId());
        if (user.getStatus() != null) {
            userEntity.setStatus(user.getStatus().name());
        }
        userEntity.setLoginCount(user.getLoginCount());
        userEntity.setNewsletterSubscribed(user.getNewsletterSubscribed());
        if (customUserFields != null && !customUserFields.isEmpty()) {
            Maps.MapBuilder builder = Maps.builder();
            for (UserMetadataEntity meta : customUserFields) {
                builder.put((Object)meta.getKey(), (Object)meta.getValue());
            }
            userEntity.setCustomFields(builder.build());
        }
        return userEntity;
    }
}

