/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.net.InternetDomainName;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.exception.HttpListenerPathMissingException;
import io.gravitee.rest.api.service.v4.exception.InvalidHostException;
import io.gravitee.rest.api.service.v4.exception.PathAlreadyExistsException;
import io.gravitee.rest.api.service.v4.validation.PathValidationService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PathValidationServiceImpl
implements PathValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PathValidationServiceImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final char URI_PATH_SEPARATOR_CHAR = '/';
    private final ApiRepository apiRepository;
    private final ObjectMapper objectMapper;
    private final EnvironmentService environmentService;

    public PathValidationServiceImpl(@Lazy ApiRepository apiRepository, ObjectMapper objectMapper, EnvironmentService environmentService) {
        this.apiRepository = apiRepository;
        this.objectMapper = objectMapper;
        this.environmentService = environmentService;
    }

    @Override
    public List<Path> validateAndSanitizePaths(ExecutionContext executionContext, String apiId, List<Path> paths) {
        if (paths == null || paths.isEmpty()) {
            throw new HttpListenerPathMissingException();
        }
        List<Path> sanitizedPaths = paths.stream().map(path -> new Path(path.getHost(), this.sanitizePath(path.getPath()), path.isOverrideAccess())).collect(Collectors.toList());
        EnvironmentEntity currentEnv = this.environmentService.findById(executionContext.getEnvironmentId());
        this.validateDomainRestrictions(sanitizedPaths, currentEnv.getDomainRestrictions());
        this.apiRepository.search(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).build(), null, new ApiFieldFilter.Builder().excludePicture().build()).filter(api -> !api.getId().equals(apiId)).map(this::extractPaths).filter(extractedPaths -> extractedPaths != null && !extractedPaths.isEmpty()).forEach(existingPaths -> {
            List registeredPathWithoutHost;
            Map registeredPathWithHosts = existingPaths.stream().filter(path -> !Strings.isNullOrEmpty((String)path.getHost())).collect(Collectors.groupingBy(Path::getHost, Collectors.mapping(Path::getPath, Collectors.toList())));
            if (!registeredPathWithHosts.isEmpty()) {
                sanitizedPaths.stream().filter(path -> !Strings.isNullOrEmpty((String)path.getHost())).forEach(path -> this.checkPathNotYetRegistered(path.getPath(), (List)registeredPathWithHosts.get(path.getHost())));
            }
            if (!(registeredPathWithoutHost = existingPaths.stream().filter(path -> Strings.isNullOrEmpty((String)path.getHost())).map(Path::getPath).collect(Collectors.toList())).isEmpty()) {
                sanitizedPaths.stream().filter(path -> Strings.isNullOrEmpty((String)path.getHost())).forEach(virtualHost -> this.checkPathNotYetRegistered(virtualHost.getPath(), registeredPathWithoutHost));
            }
        });
        return sanitizedPaths;
    }

    private void checkPathNotYetRegistered(String path, List<String> registeredPaths) {
        boolean match;
        boolean bl = match = registeredPaths != null && registeredPaths.stream().anyMatch(registeredPath -> path.startsWith((String)registeredPath) || registeredPath.startsWith(path));
        if (match) {
            throw new PathAlreadyExistsException(path);
        }
    }

    private List<Path> extractPaths(io.gravitee.repository.management.model.Api api) {
        if (api.getDefinition() != null) {
            if (api.getDefinitionVersion() == DefinitionVersion.V4) {
                try {
                    Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                    return apiDefinition.getListeners().stream().filter(listener -> listener instanceof HttpListener).map(listener -> (HttpListener)listener).flatMap(httpListener -> httpListener.getPaths().stream().map(path -> new Path(path.getHost(), this.sanitizePath(path.getPath())))).collect(Collectors.toList());
                }
                catch (IOException ioe) {
                    log.error("Unexpected error while getting API definition", (Throwable)ioe);
                }
            } else {
                try {
                    io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                    return apiDefinition.getProxy().getVirtualHosts().stream().map(virtualHost -> new Path(virtualHost.getHost(), this.sanitizePath(virtualHost.getPath()))).collect(Collectors.toList());
                }
                catch (IOException ioe) {
                    log.error("Unexpected error while getting API definition", (Throwable)ioe);
                }
            }
        }
        return null;
    }

    @Override
    public String sanitizePath(String path) {
        Object sanitizedPath = path;
        if (sanitizedPath == null || ((String)sanitizedPath).isEmpty()) {
            sanitizedPath = URI_PATH_SEPARATOR;
        }
        if (!((String)sanitizedPath).startsWith(URI_PATH_SEPARATOR)) {
            sanitizedPath = URI_PATH_SEPARATOR + (String)sanitizedPath;
        }
        if (((String)sanitizedPath).lastIndexOf(47) != ((String)sanitizedPath).length() - 1) {
            sanitizedPath = (String)sanitizedPath + URI_PATH_SEPARATOR;
        }
        return DUPLICATE_SLASH_REMOVER.matcher((CharSequence)sanitizedPath).replaceAll(URI_PATH_SEPARATOR);
    }

    private void validateDomainRestrictions(List<Path> paths, List<String> domainRestrictions) {
        if (domainRestrictions != null && !domainRestrictions.isEmpty()) {
            for (Path path : paths) {
                String host = path.getHost();
                if (!StringUtils.isEmpty((CharSequence)host)) {
                    String hostWithoutPort = host.split(":")[0];
                    if (this.isValidDomainOrSubDomain(hostWithoutPort, domainRestrictions)) continue;
                    throw new InvalidHostException(hostWithoutPort, domainRestrictions);
                }
                path.setHost(domainRestrictions.get(0));
            }
        }
    }

    private boolean isValidDomainOrSubDomain(String domain, List<String> domainRestrictions) {
        boolean isSubDomain = false;
        if (domainRestrictions.isEmpty()) {
            return true;
        }
        for (String domainRestriction : domainRestrictions) {
            InternetDomainName parentIDN;
            InternetDomainName domainIDN = InternetDomainName.from((String)domain);
            if (domainIDN.equals((Object)(parentIDN = InternetDomainName.from((String)domainRestriction)))) {
                return true;
            }
            while (!isSubDomain && domainIDN.hasParent()) {
                isSubDomain = parentIDN.equals((Object)domainIDN);
                domainIDN = domainIDN.parent();
            }
            if (!isSubDomain) continue;
            break;
        }
        return isSubDomain;
    }
}

