/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.entrypoint.Entrypoint;
import io.gravitee.node.api.license.NodeLicenseService;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenFeatureException;
import io.gravitee.rest.api.service.v4.ApiLicenseService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ApiLicenseServiceImpl
implements ApiLicenseService {
    private final NodeLicenseService nodeLicenseService;
    private final ApiSearchService apiSearchService;
    private static final Map<String, String> ENDPOINT_FEATURES = Map.of("kafka", "apim-en-endpoint-kafka", "mqtt5", "apim-en-endpoint-mqtt5", "rabbitmq", "apim-en-endpoint-rabbitmq");
    private static final Map<String, String> ENTRYPOINT_FEATURES = Map.of("http-post", "apim-en-entrypoint-http-post", "http-get", "apim-en-entrypoint-http-get", "webhook", "apim-en-entrypoint-webhook", "websocket", "apim-en-entrypoint-websocket", "sse", "apim-en-entrypoint-sse");

    public ApiLicenseServiceImpl(NodeLicenseService nodeLicenseService, ApiSearchService apiSearchService) {
        this.nodeLicenseService = nodeLicenseService;
        this.apiSearchService = apiSearchService;
    }

    @Override
    public void checkLicense(ExecutionContext executionContext, String apiId) throws ForbiddenFeatureException {
        this.checkLicense(executionContext, this.apiSearchService.findGenericById(executionContext, apiId));
    }

    @Override
    public void checkLicense(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        if (!DefinitionVersion.V4.equals((Object)genericApiEntity.getDefinitionVersion())) {
            return;
        }
        ApiEntity apiEntity = (ApiEntity)genericApiEntity;
        this.checkEndpointGroups(apiEntity.getEndpointGroups());
        this.checkListeners(apiEntity.getListeners());
    }

    private void checkEndpointGroups(List<EndpointGroup> endpointGroups) {
        if (endpointGroups == null) {
            return;
        }
        endpointGroups.forEach(this::checkEndpointGroup);
    }

    private void checkEndpointGroup(EndpointGroup endpointGroup) {
        Optional.ofNullable(ENDPOINT_FEATURES.get(endpointGroup.getType())).filter(arg_0 -> ((NodeLicenseService)this.nodeLicenseService).isFeatureMissing(arg_0)).ifPresent(feature -> {
            throw new ForbiddenFeatureException((String)feature);
        });
    }

    private void checkListeners(List<Listener> listeners) {
        if (listeners == null) {
            return;
        }
        listeners.forEach(this::checkListener);
    }

    private void checkListener(Listener listener) {
        if (listener.getEntrypoints() == null) {
            return;
        }
        listener.getEntrypoints().forEach(this::checkEntrypoint);
    }

    private void checkEntrypoint(Entrypoint entrypoint) {
        Optional.ofNullable(ENTRYPOINT_FEATURES.get(entrypoint.getType())).filter(arg_0 -> ((NodeLicenseService)this.nodeLicenseService).isFeatureMissing(arg_0)).ifPresent(feature -> {
            throw new ForbiddenFeatureException((String)feature);
        });
    }
}

