/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import io.gravitee.rest.api.service.v4.ApiImportExportService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.PlanService;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiImportExportServiceImpl
implements ApiImportExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiImportExportServiceImpl.class);
    private final ApiMetadataService apiMetadataService;
    private final ApiService apiServiceV4;
    private final ApiSearchService apiSearchService;
    private final MediaService mediaService;
    private final MembershipService membershipService;
    private final PageService pageService;
    private final PermissionService permissionService;
    private final PlanService planService;
    private final RoleService roleService;

    public ApiImportExportServiceImpl(ApiMetadataService apiMetadataService, ApiService apiServiceV4, ApiSearchService apiSearchService, MediaService mediaService, MembershipService membershipService, PageService pageService, PermissionService permissionService, PlanService planService, RoleService roleService) {
        this.apiMetadataService = apiMetadataService;
        this.apiServiceV4 = apiServiceV4;
        this.apiSearchService = apiSearchService;
        this.mediaService = mediaService;
        this.membershipService = membershipService;
        this.pageService = pageService;
        this.permissionService = permissionService;
        this.planService = planService;
        this.roleService = roleService;
    }

    @Override
    public ExportApiEntity exportApi(ExecutionContext executionContext, String apiId, String userId) {
        GenericApiEntity apiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
        if (apiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new ApiDefinitionVersionNotSupportedException(apiEntity.getDefinitionVersion().getLabel());
        }
        ExportApiEntity exportApi = new ExportApiEntity();
        exportApi.setApiEntity((ApiEntity)apiEntity);
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_MEMBER, apiId, RolePermissionAction.READ)) {
            Set members = this.membershipService.getMembersByReference(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, apiId).stream().filter(memberEntity -> memberEntity.getType() == MembershipMemberType.USER).collect(Collectors.toSet());
            exportApi.setMembers(members);
        }
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_METADATA, apiId, RolePermissionAction.READ)) {
            List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(apiId);
            exportApi.setMetadata(new HashSet<ApiMetadataEntity>(metadataList));
        }
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, apiId, RolePermissionAction.READ)) {
            Set<PlanEntity> plansSet = this.planService.findByApi(GraviteeContext.getExecutionContext(), apiId);
            exportApi.setPlans(plansSet);
        }
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.READ)) {
            List<PageEntity> pageList = this.pageService.findByApi(GraviteeContext.getCurrentEnvironment(), apiId);
            exportApi.setPages(pageList);
            List<MediaEntity> apiMediaList = this.mediaService.findAllByApiId(apiId);
            exportApi.setApiMedia(apiMediaList);
        }
        return exportApi;
    }

    @Override
    public GenericApiEntity createFromExportedApi(ExecutionContext executionContext, ExportApiEntity exportApiEntity, String userId) {
        ApiEntity apiEntity = exportApiEntity.getApiEntity();
        if (apiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new ApiDefinitionVersionNotSupportedException(apiEntity.getDefinitionVersion().getLabel());
        }
        ApiEntity createdApiEntity = this.apiServiceV4.createWithImport(executionContext, apiEntity, userId);
        this.createMembers(executionContext, createdApiEntity, exportApiEntity.getMembers());
        this.createPages(executionContext, createdApiEntity, exportApiEntity.getPages());
        this.createPlans(executionContext, createdApiEntity, exportApiEntity.getPlans());
        this.createMetadata(executionContext, createdApiEntity, exportApiEntity.getMetadata());
        this.createPageAndMedia(executionContext, createdApiEntity, exportApiEntity.getApiMedia());
        return createdApiEntity;
    }

    protected void createMembers(ExecutionContext executionContext, ApiEntity createdApiEntity, Set<MemberEntity> members) {
        if (members.isEmpty()) {
            return;
        }
        RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
        assert (poRole != null);
        String poRoleName = poRole.getName();
        for (MemberEntity member : members) {
            List<RoleEntity> rolesToImport = member.getRoles().stream().filter(role -> !role.getName().equals(poRoleName)).map(role -> {
                Optional<RoleEntity> roleEntity = this.roleService.findByScopeAndName(RoleScope.API, role.getName(), executionContext.getOrganizationId());
                if (roleEntity.isPresent()) {
                    return roleEntity.get();
                }
                log.warn("Unable to find role '{}' to import", (Object)role.getName());
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            rolesToImport.forEach(role -> {
                try {
                    this.membershipService.addRoleToMemberOnReference(executionContext, MembershipReferenceType.API, createdApiEntity.getId(), MembershipMemberType.USER, member.getId(), role.getId());
                }
                catch (Exception e) {
                    log.warn("Unable to add role '{}[{}]' to member '{}[{}]' on API '{}[{}]' due to : {}", new Object[]{role.getName(), role.getId(), member.getDisplayName(), member.getId(), createdApiEntity.getName(), createdApiEntity.getId(), e.getMessage()});
                }
            });
        }
    }

    protected void createPages(ExecutionContext executionContext, ApiEntity createdApiEntity, List<PageEntity> pages) {
        if (pages.isEmpty()) {
            return;
        }
        this.pageService.createOrUpdatePages(executionContext, pages, createdApiEntity.getId());
    }

    protected void createPlans(ExecutionContext executionContext, ApiEntity createdApiEntity, Set<PlanEntity> plans) {
        if (plans.isEmpty()) {
            return;
        }
        plans.forEach(planEntity -> {
            planEntity.setApiId(createdApiEntity.getId());
            this.planService.createOrUpdatePlan(executionContext, (PlanEntity)planEntity);
        });
    }

    protected void createMetadata(ExecutionContext executionContext, ApiEntity createdApiEntity, Set<ApiMetadataEntity> metadata) {
        metadata.stream().map(apiMetadataEntity -> {
            UpdateApiMetadataEntity updateApiMetadataEntity = new UpdateApiMetadataEntity();
            updateApiMetadataEntity.setApiId(createdApiEntity.getId());
            updateApiMetadataEntity.setDefaultValue(apiMetadataEntity.getDefaultValue());
            updateApiMetadataEntity.setFormat(apiMetadataEntity.getFormat());
            updateApiMetadataEntity.setKey(apiMetadataEntity.getKey());
            updateApiMetadataEntity.setName(apiMetadataEntity.getName());
            updateApiMetadataEntity.setValue(apiMetadataEntity.getValue());
            return updateApiMetadataEntity;
        }).forEach(metadataEntity -> this.apiMetadataService.update(executionContext, (UpdateApiMetadataEntity)metadataEntity));
    }

    protected void createPageAndMedia(ExecutionContext executionContext, ApiEntity createdApiEntity, List<MediaEntity> mediaEntities) {
        mediaEntities.forEach(mediaEntity -> this.mediaService.saveApiMedia(createdApiEntity.getId(), (MediaEntity)mediaEntity));
        List<PageEntity> search = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build());
        if (search.isEmpty()) {
            this.pageService.createAsideFolder(executionContext, createdApiEntity.getId());
        }
    }
}

