/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public abstract class ApiSerializer
extends StdSerializer<ApiEntity> {
    public static String METADATA_EXPORT_VERSION = "exportVersion";
    public static String METADATA_FILTERED_FIELDS_LIST = "filteredFieldsList";
    protected ApplicationContext applicationContext;

    protected ApiSerializer(Class<ApiEntity> t) {
        super(t);
    }

    public abstract Version version();

    public boolean canHandle(ApiEntity apiEntity) {
        return this.version().getVersion().equals(apiEntity.getMetadata().get(METADATA_EXPORT_VERSION));
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List filteredFieldsList;
        jsonGenerator.writeStartObject();
        if (apiEntity.getName() != null) {
            jsonGenerator.writeObjectField("name", (Object)apiEntity.getName());
        }
        if (apiEntity.getCrossId() != null) {
            jsonGenerator.writeObjectField("crossId", (Object)apiEntity.getCrossId());
        }
        if (apiEntity.getVersion() != null) {
            jsonGenerator.writeObjectField("version", (Object)apiEntity.getVersion());
        }
        if (!this.version().getVersion().startsWith("1.")) {
            if (apiEntity.getExecutionMode() != null) {
                jsonGenerator.writeObjectField("execution_mode", (Object)apiEntity.getExecutionMode().getLabel());
            } else {
                jsonGenerator.writeObjectField("execution_mode", (Object)ExecutionMode.V3.getLabel());
            }
        }
        if (apiEntity.getDescription() != null) {
            jsonGenerator.writeObjectField("description", (Object)apiEntity.getDescription());
        }
        if (apiEntity.getVisibility() != null) {
            jsonGenerator.writeObjectField("visibility", (Object)apiEntity.getVisibility());
        }
        if (apiEntity.getTags() != null && !apiEntity.getTags().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("tags");
            for (String string : apiEntity.getTags()) {
                jsonGenerator.writeObject((Object)string);
            }
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getPicture() != null) {
            jsonGenerator.writeObjectField("picture", (Object)apiEntity.getPicture());
        }
        if (DefinitionVersion.V1.getLabel().equals(apiEntity.getGraviteeDefinitionVersion())) {
            if (apiEntity.getPaths() != null) {
                jsonGenerator.writeObjectFieldStart("paths");
                for (Map.Entry entry : apiEntity.getPaths().entrySet()) {
                    jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
        } else if (apiEntity.getFlows() != null) {
            jsonGenerator.writeObjectField("flows", (Object)apiEntity.getFlows());
        }
        if (apiEntity.getGraviteeDefinitionVersion() != null) {
            jsonGenerator.writeObjectField("gravitee", (Object)apiEntity.getGraviteeDefinitionVersion());
        }
        if (apiEntity.getFlowMode() != null) {
            jsonGenerator.writeObjectField("flow_mode", (Object)apiEntity.getFlowMode().toString().toUpperCase());
        }
        if (apiEntity.getServices() != null && !apiEntity.getServices().isEmpty()) {
            jsonGenerator.writeObjectField("services", (Object)apiEntity.getServices());
        }
        if (apiEntity.getResources() != null) {
            jsonGenerator.writeArrayFieldStart("resources");
            for (Resource resource : apiEntity.getResources()) {
                jsonGenerator.writeObject((Object)resource);
            }
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getProperties() != null && apiEntity.getProperties().getValues() != null) {
            jsonGenerator.writeObjectField("properties", (Object)apiEntity.getProperties().getProperties());
        } else {
            jsonGenerator.writeObjectField("properties", Collections.emptyList());
        }
        if (apiEntity.getCategories() != null && !apiEntity.getCategories().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("categories");
            for (String string : apiEntity.getCategories()) {
                jsonGenerator.writeObject((Object)string);
            }
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getLabels() != null && !apiEntity.getLabels().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("labels");
            for (String string : apiEntity.getLabels()) {
                jsonGenerator.writeObject((Object)string);
            }
            jsonGenerator.writeEndArray();
        }
        if ((filteredFieldsList = (List)apiEntity.getMetadata().get(METADATA_FILTERED_FIELDS_LIST)) != null) {
            List<ApiMetadataEntity> list;
            if (!filteredFieldsList.contains("groups") && apiEntity.getGroups() != null && !apiEntity.getGroups().isEmpty()) {
                Set<GroupEntity> set = ((GroupService)this.applicationContext.getBean(GroupService.class)).findByIds(apiEntity.getGroups());
                jsonGenerator.writeObjectField("groups", set.stream().map(GroupEntity::getName).collect(Collectors.toSet()));
            }
            if (!filteredFieldsList.contains("members")) {
                Set<MemberEntity> set = ((MembershipService)this.applicationContext.getBean(MembershipService.class)).getMembersByReference(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, apiEntity.getId());
                ArrayList members = new ArrayList(set == null ? 0 : set.size());
                if (set != null) {
                    UserService userService = (UserService)this.applicationContext.getBean(UserService.class);
                    set.stream().filter(m -> m.getType() == MembershipMemberType.USER).forEach(m -> {
                        UserEntity userEntity = userService.findById(GraviteeContext.getExecutionContext(), m.getId());
                        if (userEntity != null) {
                            Member member = new Member();
                            member.setRoles(m.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()));
                            member.setSource(userEntity.getSource());
                            member.setSourceId(userEntity.getSourceId());
                            members.add(member);
                        }
                    });
                }
                jsonGenerator.writeObjectField("members", members);
            }
            if (!filteredFieldsList.contains("pages")) {
                void var5_22;
                List<PageEntity> list2 = ((PageService)this.applicationContext.getBean(PageService.class)).search(GraviteeContext.getCurrentEnvironment(), new PageQuery.Builder().api(apiEntity.getId()).build(), true);
                if (this.version().getVersion().startsWith("1.")) {
                    List list3 = list2.stream().filter(pageEntity -> !pageEntity.getType().equals(PageType.LINK.name()) && !pageEntity.getType().equals(PageType.TRANSLATION.name()) && !pageEntity.getType().equals(PageType.SYSTEM_FOLDER.name()) && !pageEntity.getType().equals(PageType.MARKDOWN_TEMPLATE.name()) && !pageEntity.getType().equals(PageType.ASCIIDOC.name())).collect(Collectors.toList());
                } else if (this.version().getVersion().equals("3.0")) {
                    List list4 = list2.stream().filter(pageEntity -> !pageEntity.getType().equals(PageType.MARKDOWN_TEMPLATE.name()) && !pageEntity.getType().equals(PageType.ASCIIDOC.name())).collect(Collectors.toList());
                } else if (this.version().getVersion().equals("3.7")) {
                    List list5 = list2.stream().filter(pageEntity -> !pageEntity.getType().equals(PageType.ASCIIDOC.name())).collect(Collectors.toList());
                }
                jsonGenerator.writeObjectField("pages", var5_22 == null ? Collections.emptyList() : var5_22);
                List<MediaEntity> apiMedia = ((MediaService)this.applicationContext.getBean(MediaService.class)).findAllByApiId(apiEntity.getId());
                if (apiMedia != null && !apiMedia.isEmpty()) {
                    jsonGenerator.writeObjectField("apiMedia", apiMedia);
                }
            }
            if (!filteredFieldsList.contains("plans")) {
                Set<PlanEntity> set = ((PlanService)this.applicationContext.getBean(PlanService.class)).findByApi(GraviteeContext.getExecutionContext(), apiEntity.getId());
                Set plansToAdd = set == null ? Collections.emptySet() : set.stream().filter(p -> !PlanStatus.CLOSED.equals((Object)p.getStatus())).collect(Collectors.toSet());
                jsonGenerator.writeObjectField("plans", plansToAdd);
            }
            if (!filteredFieldsList.contains("metadata") && (list = ((ApiMetadataService)this.applicationContext.getBean(ApiMetadataService.class)).findAllByApi(apiEntity.getId())) != null && !list.isEmpty()) {
                jsonGenerator.writeObjectField("metadata", list);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public static enum Version {
        DEFAULT("default");

        private final String version;

        private Version(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }

    class Member {
        private String username;
        private String source;
        private String sourceId;
        private String role;
        private List<String> roles;

        Member() {
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

