/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultRolesUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultRolesUpgrader.class);
    @Autowired
    private RoleService roleService;

    @Override
    public boolean upgrade() {
        if (this.roleService.findAll().isEmpty()) {
            this.roleService.initialize(GraviteeContext.getDefaultOrganization());
        } else {
            Optional<RoleEntity> optionalRole = this.roleService.findByScopeAndName(RoleScope.API, "REVIEWER");
            if (!optionalRole.isPresent()) {
                this.logger.info("     - <API> REVIEWER");
                this.roleService.create(DefaultRoleEntityDefinition.ROLE_API_REVIEWER);
            }
        }
        this.roleService.createOrUpdateSystemRoles(GraviteeContext.getDefaultOrganization());
        return true;
    }

    @Override
    public int getOrder() {
        return 150;
    }
}

