/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "user";

    @Override
    public SearchResult search(Query query) throws TechnicalException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"displayname", "displayname_reverted", "email", "reference"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        parser.setAllowLeadingWildcard(true);
        try {
            parser.parse(QueryParserBase.escape((String)query.getQuery()));
            BooleanQuery.Builder userQuery = new BooleanQuery.Builder();
            BooleanQuery.Builder userFieldsQuery = new BooleanQuery.Builder();
            String normalizedQuery = StringUtils.stripAccents((String)query.getQuery().toLowerCase());
            userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("displayname", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("displayname_reverted", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("email", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
            userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("reference", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
            userQuery.add((org.apache.lucene.search.Query)userFieldsQuery.build(), BooleanClause.Occur.MUST);
            userQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
            BooleanQuery.Builder orgCriteria = new BooleanQuery.Builder();
            orgCriteria.add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_type", GraviteeContext.ReferenceContextType.ORGANIZATION.name())), BooleanClause.Occur.MUST);
            orgCriteria.add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_id", GraviteeContext.getCurrentOrganization())), BooleanClause.Occur.MUST);
            userQuery.add((org.apache.lucene.search.Query)orgCriteria.build(), BooleanClause.Occur.FILTER);
            return this.search((org.apache.lucene.search.Query)userQuery.build(), query.getPage());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for user documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for user documents", (Throwable)pe);
        }
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(UserEntity.class);
    }
}

