/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.commands;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandProducer;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.hello.HelloCommand;
import io.gravitee.cockpit.api.command.hello.HelloPayload;
import io.gravitee.cockpit.api.command.hello.HelloReply;
import io.gravitee.node.api.Node;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.reactivex.Single;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="cockpitHelloCommandProducer")
public class HelloCommandProducer
implements CommandProducer<HelloCommand, HelloReply> {
    private static final String UI_URL = "UI_URL";
    private static final String API_URL = "API_URL";
    @Value(value="${console.ui.url:http://localhost:3000}")
    private String uiURL;
    @Value(value="${console.api.url:http://localhost:8083/management}")
    private String apiURL;
    private final Node node;
    private final InstallationService installationService;

    public HelloCommandProducer(Node node, InstallationService installationService) {
        this.node = node;
        this.installationService = installationService;
    }

    public Command.Type produceType() {
        return Command.Type.HELLO_COMMAND;
    }

    public Single<HelloCommand> prepare(HelloCommand command) {
        InstallationEntity installation = this.installationService.getOrInitialize();
        ((HelloPayload)command.getPayload()).getNode().setInstallationId(installation.getId());
        ((HelloPayload)command.getPayload()).getNode().setHostname(this.node.hostname());
        ((HelloPayload)command.getPayload()).getAdditionalInformation().putAll(installation.getAdditionalInformation());
        ((HelloPayload)command.getPayload()).getAdditionalInformation().put(UI_URL, this.uiURL);
        ((HelloPayload)command.getPayload()).getAdditionalInformation().put(API_URL, this.apiURL);
        ((HelloPayload)command.getPayload()).setDefaultOrganizationId(GraviteeContext.getDefaultOrganization());
        ((HelloPayload)command.getPayload()).setDefaultEnvironmentId(GraviteeContext.getDefaultEnvironment());
        return Single.just((Object)command);
    }

    public Single<HelloReply> handleReply(HelloReply reply) {
        if (reply.getCommandStatus() == CommandStatus.SUCCEEDED) {
            HashMap<String, String> additionalInformation = new HashMap<String, String>();
            additionalInformation.put("COCKPIT_INSTALLATION_ID", reply.getInstallationId());
            additionalInformation.put("COCKPIT_INSTALLATION_STATUS", reply.getInstallationStatus());
            this.installationService.setAdditionalInformation(additionalInformation);
        }
        return Single.just((Object)reply);
    }
}

