/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.commands;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.environment.EnvironmentCommand;
import io.gravitee.cockpit.api.command.environment.EnvironmentPayload;
import io.gravitee.cockpit.api.command.environment.EnvironmentReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.reactivex.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentCommandHandler
implements CommandHandler<EnvironmentCommand, EnvironmentReply> {
    private final Logger logger = LoggerFactory.getLogger(EnvironmentCommandHandler.class);
    private final EnvironmentService environmentService;

    public EnvironmentCommandHandler(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    public Command.Type handleType() {
        return Command.Type.ENVIRONMENT_COMMAND;
    }

    public Single<EnvironmentReply> handle(EnvironmentCommand command) {
        EnvironmentPayload environmentPayload = (EnvironmentPayload)command.getPayload();
        try {
            UpdateEnvironmentEntity newEnvironment = new UpdateEnvironmentEntity();
            newEnvironment.setHrids(environmentPayload.getHrids());
            newEnvironment.setName(environmentPayload.getName());
            newEnvironment.setDescription(environmentPayload.getDescription());
            newEnvironment.setDomainRestrictions(environmentPayload.getDomainRestrictions());
            EnvironmentEntity environment = this.environmentService.createOrUpdate(environmentPayload.getOrganizationId(), environmentPayload.getId(), newEnvironment);
            this.logger.info("Environment [{}] handled with id [{}].", (Object)environment.getName(), (Object)environment.getId());
            return Single.just((Object)new EnvironmentReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            this.logger.error("Error occurred when handling environment [{}] with id [{}].", new Object[]{environmentPayload.getName(), environmentPayload.getId(), e});
            return Single.just((Object)new EnvironmentReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

