/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.identity;

import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class IdentityProviderActivationNotFoundException
extends AbstractNotFoundException {
    private final String identityProviderId;
    private final String referenceId;
    private final IdentityProviderActivationReferenceType referenceType;

    public IdentityProviderActivationNotFoundException(String identityProviderId, String referenceId, IdentityProviderActivationReferenceType referenceType) {
        this.identityProviderId = identityProviderId;
        this.referenceId = referenceId;
        this.referenceType = referenceType;
    }

    @Override
    public String getMessage() {
        return String.format("Identity Provider [{}] is not Activated for {}:{}.", this.identityProviderId, this.referenceType.name(), this.referenceId);
    }

    @Override
    public String getTechnicalCode() {
        return "identityProvider.notActivated";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("identityProviderId", IdentityProviderActivationNotFoundException.this.identityProviderId);
                this.put("referenceId", IdentityProviderActivationNotFoundException.this.referenceId);
                this.put("referenceType", IdentityProviderActivationNotFoundException.this.referenceType.name());
            }
        };
    }
}

