/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.TokenRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Token;
import io.gravitee.rest.api.model.NewTokenEntity;
import io.gravitee.rest.api.model.TokenEntity;
import io.gravitee.rest.api.model.TokenReferenceType;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TokenNameAlreadyExistsException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class TokenServiceImpl
extends AbstractService
implements TokenService {
    private final Logger LOGGER = LoggerFactory.getLogger(TokenServiceImpl.class);
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    @Autowired
    private TokenRepository tokenRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public List<TokenEntity> findByUser(String userId) {
        try {
            this.LOGGER.debug("Find all tokens for user '{}'", (Object)userId);
            return this.tokenRepository.findByReference(TokenReferenceType.USER.name(), userId).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find all tokens";
            this.LOGGER.error("An error occurs while trying to find all tokens", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all tokens", ex);
        }
    }

    @Override
    public TokenEntity create(NewTokenEntity newToken) {
        try {
            String username = this.getAuthenticatedUsername();
            List<TokenEntity> tokens = this.findByUser(username);
            boolean nameAlreadyExists = tokens.stream().anyMatch(token -> newToken.getName().equalsIgnoreCase(token.getName()));
            if (nameAlreadyExists) {
                throw new TokenNameAlreadyExistsException(newToken.getName());
            }
            String decodedToken = io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
            Token token2 = this.convert(newToken, TokenReferenceType.USER, username, this.passwordEncoder.encode((CharSequence)decodedToken));
            this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.TOKEN, token2.getId()), (Audit.AuditEvent)Token.AuditEvent.TOKEN_CREATED, token2.getCreatedAt(), null, token2);
            return this.convert((Token)this.tokenRepository.create((Object)token2), decodedToken);
        }
        catch (TechnicalException e) {
            String error = "An error occurs while trying to create a token " + newToken;
            this.LOGGER.error(error, (Throwable)e);
            throw new TechnicalManagementException(error, e);
        }
    }

    @Override
    public void revokeByUser(String userId) {
        List<TokenEntity> tokens = this.findByUser(userId);
        tokens.forEach(token -> this.revoke(token.getId()));
    }

    @Override
    public void revoke(String tokenId) {
        try {
            Optional tokenOptional = this.tokenRepository.findById((Object)tokenId);
            if (tokenOptional.isPresent()) {
                this.tokenRepository.delete((Object)tokenId);
                this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.TOKEN, tokenId), (Audit.AuditEvent)Token.AuditEvent.TOKEN_DELETED, new Date(), null, tokenOptional.get());
            }
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to delete token " + tokenId;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public Token findByToken(String token) {
        try {
            this.LOGGER.debug("Find token entity by token value");
            Token matchingToken = this.tokenRepository.findAll().stream().sorted(Comparator.comparing(Token::getLastUseAt, Comparator.nullsLast(Collections.reverseOrder()))).filter(t -> this.passwordEncoder.matches((CharSequence)token, t.getToken())).findFirst().orElseThrow(() -> new IllegalStateException("Token not found"));
            matchingToken.setLastUseAt(new Date());
            return (Token)this.tokenRepository.update((Object)matchingToken);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find token entity for a given token value";
            this.LOGGER.error("An error occurs while trying to find token entity for a given token value", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find token entity for a given token value", ex);
        }
    }

    private Token convert(NewTokenEntity tokenEntity, TokenReferenceType referenceType, String referenceId, String encodedToken) {
        Token token = new Token();
        token.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        token.setToken(encodedToken);
        token.setName(tokenEntity.getName());
        token.setCreatedAt(new Date());
        token.setReferenceType(referenceType.name());
        token.setReferenceId(referenceId);
        return token;
    }

    private TokenEntity convert(Token token) {
        return this.convert(token, null);
    }

    private TokenEntity convert(Token token, String decodedToken) {
        TokenEntity tokenEntity = new TokenEntity();
        tokenEntity.setId(token.getId());
        tokenEntity.setToken(decodedToken);
        tokenEntity.setName(token.getName());
        tokenEntity.setCreatedAt(token.getCreatedAt());
        tokenEntity.setExpiresAt(token.getExpiresAt());
        tokenEntity.setLastUseAt(token.getLastUseAt());
        return tokenEntity;
    }
}

