/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.EndpointType;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.jackson.ser.api.PlanEntityBefore_3_00;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Api1_15VersionSerializer
extends ApiSerializer {
    public Api1_15VersionSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List filteredFieldsList;
        super.serialize(apiEntity, jsonGenerator, serializerProvider);
        if (apiEntity.getProxy() != null) {
            jsonGenerator.writeObjectFieldStart("proxy");
            Iterator virtualHostIterator = apiEntity.getProxy().getVirtualHosts().iterator();
            if (virtualHostIterator.hasNext()) {
                jsonGenerator.writeObjectField("context_path", (Object)((VirtualHost)virtualHostIterator.next()).getPath());
            }
            jsonGenerator.writeObjectField("strip_context_path", (Object)apiEntity.getProxy().isStripContextPath());
            if (apiEntity.getProxy().getLogging() == null) {
                jsonGenerator.writeObjectField("loggingMode", (Object)LoggingMode.NONE);
            } else {
                jsonGenerator.writeObjectField("loggingMode", (Object)apiEntity.getProxy().getLogging().getMode());
            }
            jsonGenerator.writeObjectField("endpoints", apiEntity.getProxy().getGroups().stream().map(endpointGroup -> endpointGroup.getEndpoints()).flatMap(Collection::stream).filter(endpoint -> endpoint.getType() == EndpointType.HTTP).collect(Collectors.toList()));
            jsonGenerator.writeObjectField("load_balancing", (Object)((EndpointGroup)apiEntity.getProxy().getGroups().iterator().next()).getLoadBalancer());
            if (apiEntity.getProxy().getFailover() != null) {
                jsonGenerator.writeObjectField("failover", (Object)apiEntity.getProxy().getFailover());
            }
            if (apiEntity.getProxy().getCors() != null) {
                jsonGenerator.writeObjectField("cors", (Object)apiEntity.getProxy().getCors());
            }
            jsonGenerator.writeEndObject();
        }
        if (!(filteredFieldsList = (List)apiEntity.getMetadata().get(METADATA_FILTERED_FIELDS_LIST)).contains("members")) {
            ArrayList members;
            Set<MemberEntity> memberEntities = ((MembershipService)this.applicationContext.getBean(MembershipService.class)).getMembersByReference(MembershipReferenceType.API, apiEntity.getId());
            ArrayList arrayList = members = memberEntities == null ? Collections.emptyList() : new ArrayList(memberEntities.size());
            if (memberEntities != null && !memberEntities.isEmpty()) {
                memberEntities.forEach(m -> {
                    UserEntity userEntity = ((UserService)this.applicationContext.getBean(UserService.class)).findById(m.getId());
                    if (userEntity != null) {
                        ApiSerializer.Member member = new ApiSerializer.Member(this);
                        member.setUsername(Api1_15VersionSerializer.getUsernameFromSourceId(userEntity.getSourceId()));
                        member.setRole(((RoleEntity)m.getRoles().get(0)).getName());
                        members.add(member);
                    }
                });
            }
            jsonGenerator.writeObjectField("members", members);
        }
        if (!filteredFieldsList.contains("plans")) {
            Set<PlanEntity> plans = ((PlanService)this.applicationContext.getBean(PlanService.class)).findByApi(apiEntity.getId());
            Set plansToAdd = plans == null ? Collections.emptySet() : plans.stream().filter(p -> !PlanStatus.CLOSED.equals((Object)p.getStatus())).map(PlanEntityBefore_3_00::fromNewPlanEntity).collect(Collectors.toSet());
            jsonGenerator.writeObjectField("plans", plansToAdd);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public ApiSerializer.Version version() {
        return ApiSerializer.Version.V_1_15;
    }
}

