/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RatingAnswerRepository;
import io.gravitee.repository.management.api.RatingRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Rating;
import io.gravitee.repository.management.model.RatingAnswer;
import io.gravitee.repository.management.model.RatingReferenceType;
import io.gravitee.rest.api.model.NewRatingAnswerEntity;
import io.gravitee.rest.api.model.NewRatingEntity;
import io.gravitee.rest.api.model.RatingAnswerEntity;
import io.gravitee.rest.api.model.RatingEntity;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.UpdateRatingEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.exceptions.ApiRatingUnavailableException;
import io.gravitee.rest.api.service.exceptions.RatingAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.RatingNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RatingServiceImpl
extends AbstractService
implements RatingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingServiceImpl.class);
    @Autowired
    private RatingRepository ratingRepository;
    @Autowired
    private RatingAnswerRepository ratingAnswerRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private ApiService apiService;

    @Override
    public RatingEntity create(NewRatingEntity ratingEntity) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Optional ratingOptional = this.ratingRepository.findByReferenceIdAndReferenceTypeAndUser(ratingEntity.getApi(), RatingReferenceType.API, this.getAuthenticatedUsername());
            if (ratingOptional.isPresent()) {
                throw new RatingAlreadyExistsException(ratingEntity.getApi(), this.getAuthenticatedUsername());
            }
            Rating rating = this.ratingRepository.create(this.convert(ratingEntity));
            this.auditService.createApiAuditLog(rating.getReferenceId(), null, (Audit.AuditEvent)Rating.RatingEvent.RATING_CREATED, rating.getCreatedAt(), null, rating);
            this.notifierService.trigger(ApiHook.NEW_RATING, rating.getReferenceId(), new NotificationParamsBuilder().api(this.apiService.findById(rating.getReferenceId())).build());
            return this.convert(rating);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to create rating on api {}", (Object)ratingEntity.getApi(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to create rating on api " + ratingEntity.getApi(), ex);
        }
    }

    @Override
    public RatingEntity createAnswer(NewRatingAnswerEntity answerEntity) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(answerEntity.getRatingId());
            RatingAnswer ratingAnswer = new RatingAnswer();
            ratingAnswer.setId(RandomString.generate());
            ratingAnswer.setRating(answerEntity.getRatingId());
            ratingAnswer.setUser(this.getAuthenticatedUsername());
            ratingAnswer.setComment(answerEntity.getComment());
            ratingAnswer.setCreatedAt(new Date());
            this.ratingAnswerRepository.create(ratingAnswer);
            this.auditService.createApiAuditLog(rating.getReferenceId(), null, (Audit.AuditEvent)RatingAnswer.RatingAnswerEvent.RATING_ANSWER_CREATED, ratingAnswer.getCreatedAt(), null, ratingAnswer);
            this.notifierService.trigger(ApiHook.NEW_RATING_ANSWER, rating.getReferenceId(), new NotificationParamsBuilder().api(this.apiService.findById(rating.getReferenceId())).build());
            return this.convert(rating);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to create a rating answer on rating {}", (Object)answerEntity.getRatingId(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to create a rating answer on rating" + answerEntity.getRatingId(), ex);
        }
    }

    @Override
    public RatingEntity findById(String id) {
        return this.convert(this.findModelById(id));
    }

    @Override
    public Page<RatingEntity> findByApi(String api, Pageable pageable) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Page pageRating = this.ratingRepository.findByReferenceIdAndReferenceTypePageable(api, RatingReferenceType.API, new PageableBuilder().pageNumber(pageable.pageNumber() - 1).pageSize(pageable.pageSize()).build());
            List ratingEntities = pageRating.getContent().stream().map(this::convert).collect(Collectors.toList());
            return new Page(ratingEntities, pageRating.getPageNumber(), (int)pageRating.getPageElements(), pageRating.getTotalElements());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find ratings for api {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find ratings for api " + api, ex);
        }
    }

    @Override
    public List<RatingEntity> findByApi(String api) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            List ratings = this.ratingRepository.findByReferenceIdAndReferenceType(api, RatingReferenceType.API);
            List<RatingEntity> ratingEntities = ratings.stream().map(this::convert).collect(Collectors.toList());
            return ratingEntities;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find ratings for api {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find ratings for api " + api, ex);
        }
    }

    @Override
    public RatingSummaryEntity findSummaryByApi(String api) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            List ratings = this.ratingRepository.findByReferenceIdAndReferenceType(api, RatingReferenceType.API);
            RatingSummaryEntity ratingSummary = new RatingSummaryEntity();
            ratingSummary.setApi(api);
            ratingSummary.setNumberOfRatings(ratings.size());
            OptionalDouble optionalAvg = ratings.stream().mapToInt(Rating::getRate).average();
            if (optionalAvg.isPresent()) {
                ratingSummary.setAverageRate(Double.valueOf(optionalAvg.getAsDouble()));
            }
            ratingSummary.setNumberOfRatingsByRate(ratings.stream().collect(Collectors.groupingBy(Rating::getRate, Collectors.counting())));
            return ratingSummary;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find summary rating for api {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find summary rating for api " + api, ex);
        }
    }

    @Override
    public RatingEntity findByApiForConnectedUser(String api) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Optional ratingOptional = this.ratingRepository.findByReferenceIdAndReferenceTypeAndUser(api, RatingReferenceType.API, this.getAuthenticatedUsername());
            if (ratingOptional.isPresent()) {
                return this.convert((Rating)ratingOptional.get());
            }
            return null;
        }
        catch (TechnicalException ex) {
            String message = "An error occurred while trying to find rating for api " + api + " and user " + this.getAuthenticatedUsername();
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public RatingEntity update(UpdateRatingEntity ratingEntity) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(ratingEntity.getId());
            Rating oldRating = new Rating(rating);
            if (!rating.getReferenceId().equals(ratingEntity.getApi())) {
                throw new RatingNotFoundException(ratingEntity.getId(), ratingEntity.getApi());
            }
            Date now = new Date();
            rating.setUpdatedAt(now);
            rating.setRate(ratingEntity.getRate());
            if (StringUtils.isBlank((CharSequence)rating.getTitle())) {
                rating.setTitle(ratingEntity.getTitle());
            }
            if (StringUtils.isBlank((CharSequence)rating.getComment())) {
                rating.setComment(ratingEntity.getComment());
            }
            Rating updatedRating = this.ratingRepository.update(rating);
            this.auditService.createApiAuditLog(rating.getReferenceId(), null, (Audit.AuditEvent)Rating.RatingEvent.RATING_UPDATED, updatedRating.getUpdatedAt(), oldRating, updatedRating);
            return this.convert(updatedRating);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to update rating {}", (Object)ratingEntity.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to update rating " + ratingEntity.getId(), ex);
        }
    }

    @Override
    public void delete(String id) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(id);
            this.ratingRepository.delete(id);
            this.auditService.createApiAuditLog(rating.getReferenceId(), null, (Audit.AuditEvent)Rating.RatingEvent.RATING_DELETED, new Date(), rating, null);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete rating {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete rating " + id, ex);
        }
    }

    @Override
    public void deleteAnswer(String ratingId, String answerId) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(ratingId);
            this.ratingAnswerRepository.delete(answerId);
            this.auditService.createApiAuditLog(rating.getReferenceId(), null, (Audit.AuditEvent)RatingAnswer.RatingAnswerEvent.RATING_ANSWER_DELETED, new Date(), rating, null);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete rating answer {}", (Object)answerId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete rating answer " + answerId, ex);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.parameterService.findAsBoolean(Key.PORTAL_RATING_ENABLED, ParameterReferenceType.ENVIRONMENT);
    }

    private Rating findModelById(String id) {
        if (!this.isEnabled()) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Optional ratingOptional = this.ratingRepository.findById(id);
            if (!ratingOptional.isPresent()) {
                throw new RatingNotFoundException(id);
            }
            return (Rating)ratingOptional.get();
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find a rating by id {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find a rating by id " + id, ex);
        }
    }

    private RatingEntity convert(Rating rating) {
        RatingEntity ratingEntity = new RatingEntity();
        UserEntity user = this.userService.findById(rating.getUser());
        ratingEntity.setUser(user.getId());
        ratingEntity.setUserDisplayName(user.getDisplayName());
        ratingEntity.setId(rating.getId());
        ratingEntity.setApi(rating.getReferenceId());
        ratingEntity.setTitle(rating.getTitle());
        ratingEntity.setComment(rating.getComment());
        ratingEntity.setRate(rating.getRate());
        ratingEntity.setCreatedAt(rating.getCreatedAt());
        ratingEntity.setUpdatedAt(rating.getUpdatedAt());
        try {
            List ratingAnswers = this.ratingAnswerRepository.findByRating(rating.getId());
            if (ratingAnswers != null) {
                ratingEntity.setAnswers(ratingAnswers.stream().map(ratingAnswer -> {
                    RatingAnswerEntity ratingAnswerEntity = new RatingAnswerEntity();
                    ratingAnswerEntity.setId(ratingAnswer.getId());
                    UserEntity userAnswer = this.userService.findById(ratingAnswer.getUser());
                    ratingAnswerEntity.setUser(userAnswer.getId());
                    if (userAnswer.getFirstname() != null && userAnswer.getLastname() != null) {
                        ratingAnswerEntity.setUserDisplayName(userAnswer.getFirstname() + ' ' + userAnswer.getLastname());
                    } else {
                        ratingAnswerEntity.setUserDisplayName(userAnswer.getEmail());
                    }
                    ratingAnswerEntity.setComment(ratingAnswer.getComment());
                    ratingAnswerEntity.setCreatedAt(ratingAnswer.getCreatedAt());
                    return ratingAnswerEntity;
                }).sorted(Comparator.comparing(RatingAnswerEntity::getCreatedAt, Comparator.reverseOrder())).collect(Collectors.toList()));
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find rating answers by rating id {}", (Object)rating.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find rating answers by rating id " + rating.getId(), ex);
        }
        return ratingEntity;
    }

    private Rating convert(NewRatingEntity ratingEntity) {
        Rating rating = new Rating();
        rating.setId(RandomString.generate());
        rating.setReferenceId(ratingEntity.getApi());
        rating.setReferenceType(RatingReferenceType.API);
        rating.setRate(ratingEntity.getRate());
        rating.setTitle(ratingEntity.getTitle());
        rating.setComment(ratingEntity.getComment());
        rating.setUser(this.getAuthenticatedUsername());
        Date now = new Date();
        rating.setCreatedAt(now);
        rating.setUpdatedAt(now);
        return rating;
    }
}

