/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.model.EndpointType;
import io.gravitee.definition.model.ResponseTemplates;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Api3_0VersionSerializer
extends ApiSerializer {
    public Api3_0VersionSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        super.serialize(apiEntity, jsonGenerator, serializerProvider);
        if (apiEntity.getPathMappings() != null) {
            jsonGenerator.writeArrayFieldStart("path_mappings");
            apiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    jsonGenerator.writeObject(pathMapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getProxy() != null) {
            Set groups = apiEntity.getProxy().getGroups();
            if (groups != null) {
                groups.forEach(grp -> {
                    if (grp.getEndpoints() != null) {
                        grp.setEndpoints(grp.getEndpoints().stream().filter(endpoint -> endpoint.getType() == EndpointType.HTTP).collect(Collectors.toSet()));
                    }
                });
            }
            jsonGenerator.writeObjectField("proxy", (Object)apiEntity.getProxy());
        }
        if (apiEntity.getResponseTemplates() != null) {
            jsonGenerator.writeObjectFieldStart("response_templates");
            for (Map.Entry rt : apiEntity.getResponseTemplates().entrySet()) {
                jsonGenerator.writeObjectFieldStart((String)rt.getKey());
                for (Map.Entry entry : ((ResponseTemplates)rt.getValue()).getTemplates().entrySet()) {
                    jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public ApiSerializer.Version version() {
        return ApiSerializer.Version.V_3_0;
    }
}

