/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ApiMetadataNotFoundException
extends AbstractNotFoundException {
    private final String apiId;
    private final String metadataId;

    public ApiMetadataNotFoundException(String apiId, String metadataId) {
        this.apiId = apiId;
        this.metadataId = metadataId;
    }

    @Override
    public String getMessage() {
        return "The metadata [" + this.metadataId + "] can not be found on the api [" + this.apiId + "].";
    }

    @Override
    public String getTechnicalCode() {
        return "api.metadata.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("api", ApiMetadataNotFoundException.this.apiId);
                this.put("metadata", ApiMetadataNotFoundException.this.metadataId);
            }
        };
    }
}

