/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "user";

    @Override
    public SearchResult search(Query query) throws TechnicalException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"displayname", "displayname_reverted", "email", "reference"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        parser.setAllowLeadingWildcard(true);
        BooleanQuery.Builder userQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder userFieldsQuery = new BooleanQuery.Builder();
        try {
            parser.parse(QueryParserBase.escape((String)query.getQuery()));
            String normalizedQuery = StringUtils.stripAccents((String)query.getQuery().toLowerCase());
            if (this.isUserIdFormat(query)) {
                userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("id", normalizedQuery)), BooleanClause.Occur.MUST);
            } else {
                userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("displayname", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
                userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("displayname_reverted", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
                userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("email", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
                userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("reference", '*' + normalizedQuery + '*')), BooleanClause.Occur.SHOULD);
            }
            userQuery.add((org.apache.lucene.search.Query)userFieldsQuery.build(), BooleanClause.Occur.MUST);
            userQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
            return this.search((org.apache.lucene.search.Query)userQuery.build(), query.getPage());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for user documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for user documents", (Throwable)pe);
        }
    }

    private boolean isUserIdFormat(Query query) {
        try {
            UUID.fromString(query.getQuery());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(UserEntity.class);
    }
}

