/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class StillPrimaryOwnerException
extends AbstractManagementException {
    private final long apiCount;
    private final long applicationCount;

    public StillPrimaryOwnerException(long apiCount, long applicationCount) {
        this.apiCount = apiCount;
        this.applicationCount = applicationCount;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "The user is still primary owner of '" + this.apiCount + "' APIs and '" + this.applicationCount + "' Applications.";
    }

    @Override
    public String getTechnicalCode() {
        return "user.notDeletable";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("apiCount", String.valueOf(StillPrimaryOwnerException.this.apiCount));
                this.put("applicationCount", String.valueOf(StillPrimaryOwnerException.this.applicationCount));
            }
        };
    }
}

