/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DefaultRolesUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRolesUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public DefaultRolesUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        super("DEFAULT_ROLES_UPGRADER_STATUS");
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    @Override
    protected void processOneShotUpgrade() throws TechnicalException {
        this.organizationRepository.findAll().forEach(organization -> {
            ExecutionContext executionContext = new ExecutionContext((Organization)organization);
            this.initializeDefaultRoles(executionContext);
            this.roleService.createOrUpdateSystemRoles(executionContext, executionContext.getOrganizationId());
        });
    }

    private void initializeDefaultRoles(ExecutionContext executionContext) {
        if (this.roleService.findAllByOrganization(executionContext.getOrganizationId()).isEmpty()) {
            this.roleService.initialize(executionContext, executionContext.getOrganizationId());
        } else if (this.shouldCreateApiReviewerRole(executionContext)) {
            LOGGER.info("     - <API> REVIEWER");
            this.roleService.create(executionContext, DefaultRoleEntityDefinition.ROLE_API_REVIEWER);
        }
    }

    private boolean shouldCreateApiReviewerRole(ExecutionContext executionContext) {
        return this.roleService.findByScopeAndName(RoleScope.API, DefaultRoleEntityDefinition.ROLE_API_REVIEWER.getName(), executionContext.getOrganizationId()).isEmpty();
    }

    @Override
    public int getOrder() {
        return 120;
    }
}

