/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.ApiTagService;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiTagServiceImpl
implements ApiTagService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiTagServiceImpl.class);
    private final ApiRepository apiRepository;
    private final EnvironmentService environmentService;
    private final ObjectMapper objectMapper;
    private final ApiNotificationService apiNotificationService;
    private final AuditService auditService;

    public ApiTagServiceImpl(@Lazy ApiRepository apiRepository, EnvironmentService environmentService, ObjectMapper objectMapper, ApiNotificationService apiNotificationService, AuditService auditService) {
        this.apiRepository = apiRepository;
        this.environmentService = environmentService;
        this.objectMapper = objectMapper;
        this.apiNotificationService = apiNotificationService;
        this.auditService = auditService;
    }

    @Override
    public void deleteTagFromAPIs(ExecutionContext executionContext, String tagId) {
        this.environmentService.findByOrganization(executionContext.getOrganizationId()).stream().map(ExecutionContext::new).flatMap(context -> {
            ApiCriteria criteria = new ApiCriteria.Builder().environmentId(context.getEnvironmentId()).build();
            return this.apiRepository.search(criteria, null, ApiFieldFilter.allFields());
        }).forEach(api -> this.removeTag(executionContext, (io.gravitee.repository.management.model.Api)api, tagId));
    }

    private void removeTag(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, String tagId) throws TechnicalManagementException {
        try {
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            io.gravitee.repository.management.model.Api updated = null;
            if (api.getDefinitionVersion() != DefinitionVersion.V4) {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                if (apiDefinition.getTags().remove(tagId)) {
                    api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
                    updated = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                }
            } else {
                Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                if (apiDefinition.getTags().remove(tagId)) {
                    api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
                    updated = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                }
            }
            if (updated != null) {
                this.apiNotificationService.triggerUpdateNotification(executionContext, api);
                this.auditService.createApiAuditLog(executionContext, api.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, updated);
            }
        }
        catch (Exception ex) {
            throw new TechnicalManagementException("An error occurs while removing tag from API: " + api.getId(), ex);
        }
    }
}

