/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.goodbye.GoodbyeCommand;
import io.gravitee.cockpit.api.command.goodbye.GoodbyeReply;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.reactivex.Single;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GoodbyeCommandHandler
implements CommandHandler<GoodbyeCommand, GoodbyeReply> {
    static final String DELETED_STATUS = "DELETED";
    private final Logger logger = LoggerFactory.getLogger(GoodbyeCommandHandler.class);
    private final InstallationService installationService;
    private final PromotionService promotionService;

    public GoodbyeCommandHandler(InstallationService installationService, PromotionService promotionService) {
        this.installationService = installationService;
        this.promotionService = promotionService;
    }

    public Command.Type handleType() {
        return Command.Type.GOODBYE_COMMAND;
    }

    public Single<GoodbyeReply> handle(GoodbyeCommand command) {
        Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
        additionalInformation.put("COCKPIT_INSTALLATION_STATUS", DELETED_STATUS);
        this.rejectAllPromotionToValidate();
        try {
            this.installationService.setAdditionalInformation(additionalInformation);
            this.logger.info("Installation status is [{}].", (Object)DELETED_STATUS);
            return Single.just((Object)new GoodbyeReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception ex) {
            this.logger.info("Error occurred when deleting installation.", (Throwable)ex);
            return Single.just((Object)new GoodbyeReply(command.getId(), CommandStatus.ERROR));
        }
    }

    private void rejectAllPromotionToValidate() {
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(List.of(PromotionEntityStatus.TO_BE_VALIDATED));
        this.promotionService.search(promotionQuery, null, null).getContent().forEach(promotionEntity -> {
            promotionEntity.setStatus(PromotionEntityStatus.REJECTED);
            this.promotionService.createOrUpdate((PromotionEntity)promotionEntity);
        });
    }
}

