/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.entrypoint.Entrypoint;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.EntrypointPluginService;
import io.gravitee.rest.api.service.v4.exception.HttpListenerEntrypointMissingException;
import io.gravitee.rest.api.service.v4.exception.HttpListenerEntrypointMissingTypeException;
import io.gravitee.rest.api.service.v4.exception.ListenersDuplicatedException;
import io.gravitee.rest.api.service.v4.validation.CorsValidationService;
import io.gravitee.rest.api.service.v4.validation.ListenerValidationService;
import io.gravitee.rest.api.service.v4.validation.LoggingValidationService;
import io.gravitee.rest.api.service.v4.validation.PathValidationService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ListenerValidationServiceImpl
extends TransactionalService
implements ListenerValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListenerValidationServiceImpl.class);
    private final PathValidationService pathValidationService;
    private final EntrypointPluginService entrypointService;
    private final CorsValidationService corsValidationService;
    private final LoggingValidationService loggingValidationService;

    public ListenerValidationServiceImpl(PathValidationService pathValidationService, EntrypointPluginService entrypointService, CorsValidationService corsValidationService, LoggingValidationService loggingValidationService) {
        this.pathValidationService = pathValidationService;
        this.entrypointService = entrypointService;
        this.corsValidationService = corsValidationService;
        this.loggingValidationService = loggingValidationService;
    }

    @Override
    public List<Listener> validateAndSanitize(ExecutionContext executionContext, String apiId, List<Listener> listeners) {
        if (listeners != null && !listeners.isEmpty()) {
            this.checkDuplicatedListeners(listeners);
            listeners.forEach(listener -> {
                switch (listener.getType()) {
                    case HTTP: {
                        this.validateAndSanitizeHttpListener(executionContext, apiId, (HttpListener)listener);
                        break;
                    }
                }
            });
        }
        return listeners;
    }

    private void checkDuplicatedListeners(List<Listener> listeners) {
        HashSet seenListeners = new HashSet();
        Set<String> duplicatedListeners = listeners.stream().filter(e -> !seenListeners.add(e)).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
        if (!duplicatedListeners.isEmpty()) {
            throw new ListenersDuplicatedException(duplicatedListeners);
        }
    }

    private void validateAndSanitizeHttpListener(ExecutionContext executionContext, String apiId, HttpListener httpListener) {
        httpListener.setPaths(this.pathValidationService.validateAndSanitizePaths(executionContext, apiId, httpListener.getPaths()));
        this.validatePathMappings(httpListener.getPathMappings());
        this.validateEntrypointsConfiguration(httpListener.getEntrypoints());
        httpListener.setCors(this.corsValidationService.validateAndSanitize(httpListener.getCors()));
        httpListener.setLogging(this.loggingValidationService.validateAndSanitize(executionContext, httpListener.getLogging()));
    }

    private void validateEntrypointsConfiguration(List<Entrypoint> entrypoints) {
        if (entrypoints == null || entrypoints.isEmpty()) {
            throw new HttpListenerEntrypointMissingException();
        }
        entrypoints.forEach(entrypoint -> {
            if (entrypoint.getType() == null) {
                throw new HttpListenerEntrypointMissingTypeException();
            }
            String entrypointConfiguration = null;
            if (entrypoint.getConfiguration() != null) {
                entrypointConfiguration = entrypoint.getConfiguration();
            }
            entrypoint.setConfiguration(this.entrypointService.validateEntrypointConfiguration(entrypoint.getType(), entrypointConfiguration));
        });
    }

    private void validatePathMappings(Set<String> pathMappings) {
        if (pathMappings != null) {
            pathMappings.forEach(pathMapping -> {
                try {
                    Pattern.compile(pathMapping);
                }
                catch (PatternSyntaxException pse) {
                    String errorMsg = String.format("An error occurs while trying to parse the path mapping '%s'", pathMapping);
                    log.error(errorMsg, (Throwable)pse);
                    throw new TechnicalManagementException(errorMsg, pse);
                }
            });
        }
    }
}

