/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.exception.FlowSelectorsDuplicatedException;
import io.gravitee.rest.api.service.v4.validation.FlowValidationService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class FlowValidationServiceImpl
extends TransactionalService
implements FlowValidationService {
    private final PolicyService policyService;

    public FlowValidationServiceImpl(PolicyService policyService) {
        this.policyService = policyService;
    }

    @Override
    public List<Flow> validateAndSanitize(List<Flow> flows) {
        if (flows != null) {
            flows.forEach(flow -> {
                this.checkDuplicatedSelectors((Flow)flow);
                this.checkPolicyConfiguration((Flow)flow);
            });
        }
        return flows;
    }

    private void checkPolicyConfiguration(Flow flow) {
        Stream.of(flow.getRequest(), flow.getResponse(), flow.getSubscribe(), flow.getPublish()).filter(Objects::nonNull).flatMap(Collection::stream).filter(step -> step != null && step.getPolicy() != null && step.getConfiguration() != null).forEach(step -> step.setConfiguration(this.policyService.validatePolicyConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private void checkDuplicatedSelectors(Flow flow) {
        if (flow.getSelectors() != null) {
            HashSet seenSelectors = new HashSet();
            Set<String> duplicatedSelectors = flow.getSelectors().stream().filter(e -> !seenSelectors.add(e)).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
            if (!duplicatedSelectors.isEmpty()) {
                throw new FlowSelectorsDuplicatedException(flow.getName(), duplicatedSelectors);
            }
        }
    }
}

