/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.fetcher.api.FilesFetcher;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.rest.api.model.FetcherEntity;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.service.FetcherService;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class FetcherServiceImpl
extends AbstractPluginService<FetcherPlugin<?>, FetcherEntity>
implements FetcherService {
    public FetcherServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<FetcherPlugin<?>> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    public Set<FetcherEntity> findAll() {
        return this.findAll(false);
    }

    @Override
    public Set<FetcherEntity> findAll(boolean onlyFilesFetchers) {
        try {
            Set fetcherDefinitions = super.list();
            if (onlyFilesFetchers) {
                Class<FilesFetcher> filesFetcherClass = FilesFetcher.class;
                fetcherDefinitions = fetcherDefinitions.stream().filter(fetcherPlugin -> filesFetcherClass.isAssignableFrom(fetcherPlugin.fetcher())).collect(Collectors.toSet());
            }
            return fetcherDefinitions.stream().map(fetcherDefinition -> this.convert((FetcherPlugin)fetcherDefinition, false)).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while trying to list all fetchers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all fetchers", ex);
        }
    }

    @Override
    public FetcherEntity findById(String fetcher) {
        FetcherPlugin fetcherPlugin = (FetcherPlugin)super.get(fetcher);
        return this.convert(fetcherPlugin, true);
    }

    private FetcherEntity convert(FetcherPlugin fetcherPlugin, boolean withPlugin) {
        FetcherEntity entity = new FetcherEntity();
        entity.setId(fetcherPlugin.id());
        entity.setDescription(fetcherPlugin.manifest().description());
        entity.setName(fetcherPlugin.manifest().name());
        entity.setVersion(fetcherPlugin.manifest().version());
        if (withPlugin) {
            FetcherPlugin plugin = fetcherPlugin;
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(plugin.clazz());
            pluginEntity.setPath(plugin.path().toString());
            pluginEntity.setType(plugin.type().toString().toLowerCase());
            pluginEntity.setDependencies(plugin.dependencies());
        }
        return entity;
    }
}

