/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.parser;

import io.gravitee.rest.api.service.impl.swagger.parser.AbstractDescriptorParser;
import io.gravitee.rest.api.spec.converter.wsdl.WSDLToOpenAPIConverter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.util.RemoteUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsdlParser
extends AbstractDescriptorParser<OpenAPI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsdlParser.class);

    @Override
    public OpenAPI parse(String content) {
        try {
            if (WsdlParser.isLocationUrl(content)) {
                return new WSDLToOpenAPIConverter().toOpenAPI(RemoteUrl.urlToString((String)content, null));
            }
            return new WSDLToOpenAPIConverter().toOpenAPI(content);
        }
        catch (Exception e) {
            LOGGER.info("Wsdl parsing failed : {}", (Object)e.getMessage());
            return null;
        }
    }
}

