/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PlanValidationType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TransferSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.subscription.SubscriptionMetadataQuery;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApplicationConverter;
import io.gravitee.rest.api.service.exceptions.ApplicationArchivedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadySubscribedException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionAcceptedException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionRevisionException;
import io.gravitee.rest.api.service.exceptions.PlanNotSubscribableException;
import io.gravitee.rest.api.service.exceptions.PlanNotSubscribableWithSharedApiKeyException;
import io.gravitee.rest.api.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanOAuth2OrJWTAlreadySubscribedException;
import io.gravitee.rest.api.service.exceptions.PlanRestrictedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionAlreadyProcessedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotPausableException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotPausedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotUpdatableException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TransferNotAllowedException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionServiceImpl
extends AbstractService
implements SubscriptionService {
    private final Logger logger = LoggerFactory.getLogger(SubscriptionServiceImpl.class);
    private static final String SUBSCRIPTION_SYSTEM_VALIDATOR = "system";
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final char separator = ';';
    @Autowired
    private PlanService planService;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private UserService userService;
    @Autowired
    private PageService pageService;
    @Autowired
    private ApplicationConverter applicationConverter;

    @Override
    public SubscriptionEntity findById(String subscriptionId) {
        try {
            this.logger.debug("Find subscription by id : {}", (Object)subscriptionId);
            return this.subscriptionRepository.findById((Object)subscriptionId).map(this::convert).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a subscription using its ID: {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a subscription using its ID: %s", subscriptionId), ex);
        }
    }

    @Override
    public Set<SubscriptionEntity> findByIdIn(Collection<String> subscriptionIds) {
        try {
            return this.subscriptionRepository.findByIdIn(subscriptionIds).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            this.logger.error("An error occurs while trying to find subscriptions using IDs [{}]", subscriptionIds, (Object)e);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find subscriptions using IDs [%s]", subscriptionIds), e);
        }
    }

    @Override
    public Collection<SubscriptionEntity> findByApplicationAndPlan(ExecutionContext executionContext, String application, String plan) {
        this.logger.debug("Find subscriptions by application {} and plan {}", (Object)application, (Object)plan);
        SubscriptionQuery query = new SubscriptionQuery();
        if (plan != null) {
            query.setPlan(plan);
        }
        if (application != null && !application.trim().isEmpty()) {
            query.setApplication(application);
        } else if (this.isAuthenticated()) {
            Set<ApplicationListItem> applications = this.applicationService.findByUser(executionContext, this.getAuthenticatedUsername());
            query.setApplications((Collection)applications.stream().map(ApplicationListItem::getId).collect(Collectors.toList()));
        }
        return this.search(executionContext, query);
    }

    @Override
    public Collection<SubscriptionEntity> findByApi(ExecutionContext executionContext, String api) {
        this.logger.debug("Find subscriptions by api {}", (Object)api);
        SubscriptionQuery query = new SubscriptionQuery();
        query.setApi(api);
        return this.search(executionContext, query);
    }

    @Override
    public Collection<SubscriptionEntity> findByPlan(ExecutionContext executionContext, String plan) {
        this.logger.debug("Find subscriptions by plan {}", (Object)plan);
        SubscriptionQuery query = new SubscriptionQuery();
        query.setPlan(plan);
        return this.search(executionContext, query);
    }

    @Override
    public SubscriptionEntity create(ExecutionContext executionContext, NewSubscriptionEntity newSubscriptionEntity) {
        return this.create(executionContext, newSubscriptionEntity, null);
    }

    @Override
    public SubscriptionEntity create(ExecutionContext executionContext, NewSubscriptionEntity newSubscriptionEntity, String customApiKey) {
        String plan = newSubscriptionEntity.getPlan();
        String application = newSubscriptionEntity.getApplication();
        try {
            String clientId;
            boolean userAuthorizedToAccessApiData;
            this.logger.debug("Create a new subscription for plan {} and application {}", (Object)plan, (Object)application);
            PlanEntity planEntity = this.planService.findById(executionContext, plan);
            if (planEntity.getStatus() == PlanStatus.DEPRECATED) {
                throw new PlanNotSubscribableException(plan);
            }
            if (planEntity.getStatus() == PlanStatus.CLOSED) {
                throw new PlanAlreadyClosedException(plan);
            }
            if (planEntity.getStatus() == PlanStatus.STAGING) {
                throw new PlanNotYetPublishedException(plan);
            }
            if (planEntity.getSecurity() == PlanSecurityType.KEY_LESS) {
                throw new PlanNotSubscribableException("A key_less plan is not subscribable !");
            }
            if (!(planEntity.getExcludedGroups() == null || planEntity.getExcludedGroups().isEmpty() || (userAuthorizedToAccessApiData = this.groupService.isUserAuthorizedToAccessApiData(this.apiService.findById(executionContext, planEntity.getApi()), planEntity.getExcludedGroups(), this.getAuthenticatedUsername())) || this.isEnvironmentAdmin())) {
                throw new PlanRestrictedException(plan);
            }
            if (planEntity.getGeneralConditions() != null && !planEntity.getGeneralConditions().isEmpty()) {
                if (Boolean.FALSE.equals(newSubscriptionEntity.getGeneralConditionsAccepted()) || newSubscriptionEntity.getGeneralConditionsContentRevision() == null) {
                    throw new PlanGeneralConditionAcceptedException(planEntity.getName());
                }
                PageEntity generalConditions = this.pageService.findById(planEntity.getGeneralConditions());
                if (!generalConditions.getContentRevisionId().equals((Object)newSubscriptionEntity.getGeneralConditionsContentRevision())) {
                    throw new PlanGeneralConditionRevisionException(planEntity.getName());
                }
            }
            ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, application);
            if (ApplicationStatus.ARCHIVED.name().equals(applicationEntity.getStatus())) {
                throw new ApplicationArchivedException(applicationEntity.getName());
            }
            List subscriptions = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().applications(Collections.singleton(application)).apis(Collections.singleton(planEntity.getApi())).build());
            if (!subscriptions.isEmpty()) {
                long count;
                Predicate<Subscription> onlyValidSubs = subscription -> subscription.getStatus() != Subscription.Status.REJECTED && subscription.getStatus() != Subscription.Status.CLOSED;
                long subscriptionCount = subscriptions.stream().filter(onlyValidSubs).filter(subscription -> subscription.getPlan().equals(plan)).count();
                if (subscriptionCount > 0L) {
                    throw new PlanAlreadySubscribedException(plan);
                }
                if ((planEntity.getSecurity() == PlanSecurityType.OAUTH2 || planEntity.getSecurity() == PlanSecurityType.JWT) && (count = subscriptions.stream().filter(onlyValidSubs).map(Subscription::getPlan).distinct().map(plan1 -> this.planService.findById(executionContext, (String)plan1)).filter(subPlan -> subPlan.getSecurity() == PlanSecurityType.OAUTH2 || subPlan.getSecurity() == PlanSecurityType.JWT).count()) > 0L) {
                    throw new PlanOAuth2OrJWTAlreadySubscribedException("An other OAuth2 or JWT plan is already subscribed by the same application.");
                }
                if (planEntity.getSecurity().equals((Object)PlanSecurityType.API_KEY) && applicationEntity.hasApiKeySharedMode() && (count = subscriptions.stream().filter(onlyValidSubs).map(Subscription::getPlan).distinct().map(plan1 -> this.planService.findById(executionContext, (String)plan1)).filter(subPlan -> subPlan.getSecurity() == PlanSecurityType.API_KEY).count()) > 0L) {
                    throw new PlanNotSubscribableWithSharedApiKeyException();
                }
            }
            if (ApplicationType.SIMPLE.name().equals(applicationEntity.getType())) {
                clientId = applicationEntity.getSettings() != null && applicationEntity.getSettings().getApp() != null ? applicationEntity.getSettings().getApp().getClientId() : null;
            } else {
                String string = clientId = applicationEntity.getSettings() != null && applicationEntity.getSettings().getoAuthClient() != null ? applicationEntity.getSettings().getoAuthClient().getClientId() : null;
            }
            if (!(planEntity.getSecurity() != PlanSecurityType.OAUTH2 && planEntity.getSecurity() != PlanSecurityType.JWT || clientId != null && !clientId.trim().isEmpty())) {
                throw new PlanNotSubscribableException("A client_id is required to subscribe to an OAuth2 or JWT plan.");
            }
            this.updateApplicationApiKeyMode(executionContext, planEntity, applicationEntity);
            Subscription subscription2 = new Subscription();
            subscription2.setPlan(plan);
            subscription2.setId(UuidString.generateRandom());
            subscription2.setApplication(application);
            subscription2.setCreatedAt(new Date());
            subscription2.setUpdatedAt(subscription2.getCreatedAt());
            subscription2.setStatus(Subscription.Status.PENDING);
            subscription2.setRequest(newSubscriptionEntity.getRequest());
            subscription2.setSubscribedBy(this.getAuthenticatedUser().getUsername());
            subscription2.setClientId(clientId);
            String apiId = planEntity.getApi();
            subscription2.setApi(apiId);
            subscription2.setGeneralConditionsAccepted(newSubscriptionEntity.getGeneralConditionsAccepted());
            if (newSubscriptionEntity.getGeneralConditionsContentRevision() != null) {
                subscription2.setGeneralConditionsContentRevision(Integer.valueOf(newSubscriptionEntity.getGeneralConditionsContentRevision().getRevision()));
                subscription2.setGeneralConditionsContentPageId(newSubscriptionEntity.getGeneralConditionsContentRevision().getPageId());
            }
            subscription2 = (Subscription)this.subscriptionRepository.create((Object)subscription2);
            this.createAudit(executionContext, apiId, application, (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_CREATED, subscription2.getCreatedAt(), null, subscription2);
            ApiModelEntity api = this.apiService.findByIdForTemplates(executionContext, apiId);
            PrimaryOwnerEntity apiOwner = api.getPrimaryOwner();
            String managementURL = this.parameterService.find(executionContext, Key.MANAGEMENT_URL, ParameterReferenceType.ORGANIZATION);
            Object subscriptionsUrl = "";
            if (!StringUtils.isEmpty((CharSequence)managementURL)) {
                if (managementURL.endsWith("/")) {
                    managementURL = managementURL.substring(0, managementURL.length() - 1);
                }
                subscriptionsUrl = managementURL + "/#!/environments/" + executionContext.getEnvironmentId() + "/apis/" + api.getId() + "/subscriptions/" + subscription2.getId();
            }
            Map<String, Object> params = new NotificationParamsBuilder().api(api).plan(planEntity).application(applicationEntity).owner(apiOwner).subscription(this.convert(subscription2)).subscriptionsUrl((String)subscriptionsUrl).build();
            if (PlanValidationType.AUTO == planEntity.getValidation()) {
                ProcessSubscriptionEntity process = new ProcessSubscriptionEntity();
                process.setId(subscription2.getId());
                process.setAccepted(true);
                process.setStartingAt(new Date());
                process.setCustomApiKey(customApiKey);
                return this.process(executionContext, process, SUBSCRIPTION_SYSTEM_VALIDATOR);
            }
            this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_NEW, apiId, params);
            this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_NEW, application, params);
            return this.convert(subscription2);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to subscribe to the plan {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to subscribe to the plan %s", plan), ex);
        }
    }

    private void updateApplicationApiKeyMode(ExecutionContext executionContext, PlanEntity plan, ApplicationEntity application) {
        if (plan.getSecurity() == PlanSecurityType.API_KEY && application.getApiKeyMode() == ApiKeyMode.UNSPECIFIED && this.countApiKeySubscriptions(executionContext, application) > 0L) {
            this.logger.debug("Force application {} Api Key mode to EXCLUSIVE, as it's his second subscription", (Object)application.getId());
            application.setApiKeyMode(ApiKeyMode.EXCLUSIVE);
            this.applicationService.update(executionContext, application.getId(), this.applicationConverter.toUpdateApplicationEntity(application));
        }
    }

    @Override
    public SubscriptionEntity update(ExecutionContext executionContext, UpdateSubscriptionEntity updateSubscription) {
        return this.update(executionContext, updateSubscription, null);
    }

    @Override
    public SubscriptionEntity updateDaysToExpirationOnLastNotification(String subscriptionId, Integer value) {
        try {
            return this.subscriptionRepository.findById((Object)subscriptionId).map(subscription -> {
                subscription.setDaysToExpirationOnLastNotification(value);
                try {
                    return (Subscription)this.subscriptionRepository.update(subscription);
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to update subscription {}", (Object)subscriptionId, (Object)ex);
                    throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", subscriptionId), ex);
                }
            }).map(this::convert).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public SubscriptionEntity update(ExecutionContext executionContext, UpdateSubscriptionEntity updateSubscription, String clientId) {
        try {
            this.logger.debug("Update subscription {}", (Object)updateSubscription.getId());
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)updateSubscription.getId()).orElseThrow(() -> new SubscriptionNotFoundException(updateSubscription.getId()));
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                Subscription previousSubscription = new Subscription(subscription);
                subscription.setUpdatedAt(new Date());
                subscription.setStartingAt(updateSubscription.getStartingAt());
                subscription.setEndingAt(updateSubscription.getEndingAt());
                subscription.setDaysToExpirationOnLastNotification(null);
                if (clientId != null) {
                    subscription.setClientId(clientId);
                }
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                PlanEntity plan = this.planService.findById(executionContext, subscription.getPlan());
                this.createAudit(executionContext, plan.getApi(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
                Date endingAt = subscription.getEndingAt();
                if (plan.getSecurity() == PlanSecurityType.API_KEY && endingAt != null) {
                    this.streamActiveApiKeys(executionContext, subscription.getId()).filter(apiKey -> !apiKey.getApplication().hasApiKeySharedMode()).forEach(apiKey -> {
                        apiKey.setExpireAt(endingAt);
                        this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                    });
                }
                return this.convert(subscription);
            }
            throw new SubscriptionNotUpdatableException(updateSubscription.getId());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update subscription {}", (Object)updateSubscription.getId(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", updateSubscription.getId()), ex);
        }
    }

    @Override
    public SubscriptionEntity process(ExecutionContext executionContext, ProcessSubscriptionEntity processSubscription, String userId) {
        try {
            this.logger.debug("Subscription {} processed by {}", (Object)processSubscription.getId(), (Object)userId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)processSubscription.getId()).orElseThrow(() -> new SubscriptionNotFoundException(processSubscription.getId()));
            Subscription previousSubscription = new Subscription(subscription);
            if (subscription.getStatus() != Subscription.Status.PENDING) {
                throw new SubscriptionAlreadyProcessedException(subscription.getId());
            }
            PlanEntity plan = this.planService.findById(executionContext, subscription.getPlan());
            if (plan.getStatus() == PlanStatus.CLOSED) {
                throw new PlanAlreadyClosedException(plan.getId());
            }
            subscription.setProcessedBy(userId);
            Date now = new Date();
            subscription.setProcessedAt(now);
            subscription.setUpdatedAt(now);
            if (processSubscription.isAccepted()) {
                subscription.setStatus(Subscription.Status.ACCEPTED);
                subscription.setStartingAt(processSubscription.getStartingAt() != null ? processSubscription.getStartingAt() : new Date());
                subscription.setEndingAt(processSubscription.getEndingAt());
                subscription.setReason(processSubscription.getReason());
            } else {
                subscription.setStatus(Subscription.Status.REJECTED);
                subscription.setReason(processSubscription.getReason());
                subscription.setClosedAt(new Date());
            }
            String apiId = plan.getApi();
            ApiModelEntity api = this.apiService.findByIdForTemplates(executionContext, apiId);
            ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
            SubscriptionEntity subscriptionEntity = this.convert(subscription);
            if (plan.getSecurity() == PlanSecurityType.API_KEY && subscriptionEntity.getStatus() == SubscriptionStatus.ACCEPTED) {
                this.apiKeyService.generate(executionContext, application, subscriptionEntity, processSubscription.getCustomApiKey());
            }
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            PrimaryOwnerEntity owner = application.getPrimaryOwner();
            this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
            Map<String, Object> params = new NotificationParamsBuilder().owner(owner).application(application).api(api).plan(plan).subscription(subscriptionEntity).build();
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_ACCEPTED, apiId, params);
                this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_ACCEPTED, application.getId(), params);
                this.searchSubscriberEmail(executionContext, subscriptionEntity).ifPresent(subscriberEmail -> {
                    if (!this.notifierService.hasEmailNotificationFor(executionContext, ApplicationHook.SUBSCRIPTION_ACCEPTED, application.getId(), params, (String)subscriberEmail)) {
                        this.notifierService.triggerEmail(executionContext, ApplicationHook.SUBSCRIPTION_ACCEPTED, apiId, params, (String)subscriberEmail);
                    }
                });
            } else {
                this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_REJECTED, apiId, params);
                this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_REJECTED, application.getId(), params);
                this.searchSubscriberEmail(executionContext, subscriptionEntity).ifPresent(subscriberEmail -> {
                    if (!this.notifierService.hasEmailNotificationFor(executionContext, ApplicationHook.SUBSCRIPTION_REJECTED, application.getId(), params, (String)subscriberEmail)) {
                        this.notifierService.triggerEmail(executionContext, ApplicationHook.SUBSCRIPTION_REJECTED, apiId, params, (String)subscriberEmail);
                    }
                });
            }
            return subscriptionEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to process subscription {} by {}", new Object[]{processSubscription.getId(), userId, ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to process subscription %s by %s", processSubscription.getId(), userId), ex);
        }
    }

    private Optional<String> searchSubscriberEmail(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        try {
            UserEntity subscriber = this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy());
            return Optional.ofNullable(subscriber.getEmail());
        }
        catch (UserNotFoundException e) {
            this.logger.warn("Subscriber '{}' not found, unable to retrieve email", (Object)subscriptionEntity.getSubscribedBy());
            return Optional.empty();
        }
    }

    @Override
    public SubscriptionEntity close(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Close subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            switch (subscription.getStatus()) {
                case ACCEPTED: 
                case PAUSED: {
                    Subscription previousSubscription = new Subscription(subscription);
                    Date now = new Date();
                    subscription.setUpdatedAt(now);
                    subscription.setStatus(Subscription.Status.CLOSED);
                    subscription.setClosedAt(new Date());
                    subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                    ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
                    PlanEntity plan = this.planService.findById(executionContext, subscription.getPlan());
                    String apiId = plan.getApi();
                    ApiModelEntity api = this.apiService.findByIdForTemplates(executionContext, apiId);
                    PrimaryOwnerEntity owner = application.getPrimaryOwner();
                    Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(api).plan(plan).application(application).build();
                    this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_CLOSED, apiId, params);
                    this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_CLOSED, application.getId(), params);
                    this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_CLOSED, subscription.getUpdatedAt(), previousSubscription, subscription);
                    this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
                        if (!application.hasApiKeySharedMode()) {
                            this.apiKeyService.revoke(executionContext, (ApiKeyEntity)apiKey, false);
                        } else {
                            this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                        }
                    });
                    return this.convert(subscription);
                }
                case PENDING: {
                    ProcessSubscriptionEntity processSubscriptionEntity = new ProcessSubscriptionEntity();
                    processSubscriptionEntity.setId(subscription.getId());
                    processSubscriptionEntity.setAccepted(false);
                    processSubscriptionEntity.setReason("Subscription has been closed.");
                    return this.process(executionContext, processSubscriptionEntity, this.getAuthenticatedUsername());
                }
            }
            throw new SubscriptionNotClosableException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to close subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to close subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public SubscriptionEntity pause(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Pause subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(now);
                subscription.setStatus(Subscription.Status.PAUSED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
                PlanEntity plan = this.planService.findById(executionContext, subscription.getPlan());
                String apiId = plan.getApi();
                ApiModelEntity api = this.apiService.findByIdForTemplates(executionContext, apiId);
                PrimaryOwnerEntity owner = application.getPrimaryOwner();
                Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(api).plan(plan).application(application).build();
                this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_PAUSED, apiId, params);
                this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_PAUSED, application.getId(), params);
                this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_PAUSED, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
                    if (!application.hasApiKeySharedMode()) {
                        apiKey.setPaused(true);
                    }
                    this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                });
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausableException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to pause subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to pause subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public SubscriptionEntity resume(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Resume subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            if (subscription.getStatus() == Subscription.Status.PAUSED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(null);
                subscription.setStatus(Subscription.Status.ACCEPTED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
                PlanEntity plan = this.planService.findById(executionContext, subscription.getPlan());
                String apiId = plan.getApi();
                ApiModelEntity api = this.apiService.findByIdForTemplates(executionContext, apiId);
                PrimaryOwnerEntity owner = application.getPrimaryOwner();
                Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(api).plan(plan).application(application).build();
                this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_RESUMED, apiId, params);
                this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_RESUMED, application.getId(), params);
                this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_RESUMED, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
                    apiKey.setPaused(false);
                    this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                });
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausedException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to resume subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to resume subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public SubscriptionEntity restore(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Restore subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            if (subscription.getStatus() == Subscription.Status.CLOSED || subscription.getStatus() == Subscription.Status.REJECTED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(null);
                subscription.setStatus(Subscription.Status.PENDING);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                this.createAudit(executionContext, subscription.getApi(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_RESUMED, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
                    apiKey.setPaused(false);
                    this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                });
                return this.convert(subscription);
            }
            throw new SubscriptionNotClosedException(subscriptionId);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to restore subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to restore subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Delete subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            this.apiKeyService.findBySubscription(executionContext, subscriptionId).forEach(apiKey -> this.apiKeyService.delete(apiKey.getKey()));
            this.subscriptionRepository.delete((Object)subscriptionId);
            this.createAudit(executionContext, this.planService.findById(executionContext, subscription.getPlan()).getApi(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_DELETED, subscription.getUpdatedAt(), subscription, null);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete subscription: {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete subscription: %s", subscriptionId), ex);
        }
    }

    @Override
    public Collection<SubscriptionEntity> search(ExecutionContext executionContext, SubscriptionQuery query) {
        try {
            this.logger.debug("Search subscriptions {}", (Object)query);
            SubscriptionCriteria.Builder builder = this.toSubscriptionCriteriaBuilder(query);
            Set subscriptionsIds = null;
            if (query.getApiKey() != null && !query.getApiKey().isEmpty()) {
                if (query.getApis() != null && query.getApis().size() == 1) {
                    ApiKeyEntity apiKey = this.apiKeyService.findByKeyAndApi(executionContext, query.getApiKey(), (String)query.getApis().iterator().next());
                    if (apiKey != null) {
                        subscriptionsIds = apiKey.getSubscriptions().stream().map(SubscriptionEntity::getId).collect(Collectors.toSet());
                    }
                } else {
                    List<ApiKeyEntity> apiKeys = this.apiKeyService.findByKey(executionContext, query.getApiKey());
                    if (apiKeys != null) {
                        subscriptionsIds = apiKeys.stream().flatMap(apiKeyEntity -> apiKeyEntity.getSubscriptions().stream()).map(SubscriptionEntity::getId).collect(Collectors.toSet());
                    }
                }
            }
            builder.ids(subscriptionsIds);
            Stream<SubscriptionEntity> subscriptionsStream = this.subscriptionRepository.search(builder.build()).stream().map(this::convert);
            return subscriptionsStream.collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to search for subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for subscriptions: %s", query), ex);
        }
    }

    @Override
    public Page<SubscriptionEntity> search(ExecutionContext executionContext, SubscriptionQuery query, Pageable pageable) {
        return this.search(executionContext, query, pageable, false, false);
    }

    @Override
    public Page<SubscriptionEntity> search(ExecutionContext executionContext, SubscriptionQuery query, Pageable pageable, boolean fillApiKey, boolean fillPlanSecurityType) {
        try {
            this.logger.debug("Search pageable subscriptions {}", (Object)query);
            if (query.getApiKey() != null && !query.getApiKey().isEmpty()) {
                List filteredSubscriptions = this.apiKeyService.findByKey(executionContext, query.getApiKey()).stream().flatMap(apiKey -> this.findByIdIn(apiKey.getSubscriptionIds()).stream()).filter(subscription -> query.matchesApi(subscription.getApi()) && query.matchesApplication(subscription.getApplication()) && query.matchesPlan(subscription.getPlan()) && query.matchesStatus(subscription.getStatus())).collect(Collectors.toList());
                return new Page(filteredSubscriptions, 1, filteredSubscriptions.size(), (long)filteredSubscriptions.size());
            }
            SubscriptionCriteria.Builder builder = this.toSubscriptionCriteriaBuilder(query);
            Page pageSubscription = this.subscriptionRepository.search(builder.build(), new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
            List<SubscriptionEntity> subscriptions = pageSubscription.getContent().stream().map(this::convert).collect(Collectors.toList());
            if (fillPlanSecurityType) {
                this.fillPlanSecurityType(executionContext, subscriptions);
            }
            if (fillApiKey) {
                this.fillApiKeys(executionContext, subscriptions);
            }
            return new Page(subscriptions, pageSubscription.getPageNumber() + 1, (int)pageSubscription.getPageElements(), pageSubscription.getTotalElements());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to search for pageable subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for pageable subscriptions: %s", query), ex);
        }
    }

    private void fillPlanSecurityType(ExecutionContext executionContext, List<SubscriptionEntity> subscriptions) {
        Map<String, List<SubscriptionEntity>> subscriptionsByPlan = subscriptions.stream().filter(subscription -> subscription.getPlan() != null).collect(Collectors.groupingBy(SubscriptionEntity::getPlan));
        this.planService.findByIdIn(executionContext, subscriptionsByPlan.keySet()).forEach(plan -> ((List)subscriptionsByPlan.get(plan.getId())).forEach(subscription -> subscription.setSecurity(plan.getSecurity().name())));
    }

    private void fillApiKeys(ExecutionContext executionContext, List<SubscriptionEntity> subscriptions) {
        subscriptions.forEach(subscriptionEntity -> {
            List keys = this.streamActiveApiKeys(executionContext, subscriptionEntity.getId()).map(ApiKeyEntity::getKey).collect(Collectors.toList());
            subscriptionEntity.setKeys(keys);
        });
    }

    private SubscriptionCriteria.Builder toSubscriptionCriteriaBuilder(SubscriptionQuery query) {
        SubscriptionCriteria.Builder builder = new SubscriptionCriteria.Builder().apis(query.getApis()).applications(query.getApplications()).plans(query.getPlans()).from(query.getFrom()).to(query.getTo()).endingAtAfter(query.getEndingAtAfter()).endingAtBefore(query.getEndingAtBefore()).excludedApis(query.getExcludedApis());
        if (query.getStatuses() != null) {
            builder.statuses((Collection)query.getStatuses().stream().map(subscriptionStatus -> Subscription.Status.valueOf((String)subscriptionStatus.name())).collect(Collectors.toSet()));
        }
        if (query.getPlanSecurityTypes() != null) {
            builder.planSecurityTypes((Collection)query.getPlanSecurityTypes().stream().map(Plan.PlanSecurityType::valueOf).collect(Collectors.toList()));
        }
        return builder;
    }

    @Override
    public SubscriptionEntity transfer(ExecutionContext executionContext, TransferSubscriptionEntity transferSubscription, String userId) {
        try {
            this.logger.debug("Subscription {} transferred by {}", (Object)transferSubscription.getId(), (Object)userId);
            PlanEntity planEntity = this.planService.findById(executionContext, transferSubscription.getPlan());
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)transferSubscription.getId()).orElseThrow(() -> new SubscriptionNotFoundException(transferSubscription.getId()));
            if (planEntity.getStatus() != PlanStatus.PUBLISHED || !planEntity.getSecurity().equals((Object)this.planService.findById(executionContext, subscription.getPlan()).getSecurity()) || planEntity.getGeneralConditions() != null && !planEntity.getGeneralConditions().isEmpty()) {
                throw new TransferNotAllowedException(planEntity.getId());
            }
            Subscription previousSubscription = new Subscription(subscription);
            subscription.setUpdatedAt(new Date());
            subscription.setPlan(transferSubscription.getPlan());
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
            PlanEntity plan = this.planService.findById(executionContext, subscription.getPlan());
            String apiId = plan.getApi();
            ApiModelEntity api = this.apiService.findByIdForTemplates(executionContext, apiId);
            PrimaryOwnerEntity owner = application.getPrimaryOwner();
            this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
            SubscriptionEntity subscriptionEntity = this.convert(subscription);
            Map<String, Object> params = new NotificationParamsBuilder().owner(owner).application(application).api(api).plan(plan).subscription(subscriptionEntity).build();
            this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_TRANSFERRED, apiId, params);
            this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_TRANSFERRED, application.getId(), params);
            return subscriptionEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to transfer subscription {} by {}", new Object[]{transferSubscription.getId(), userId, ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to transfer subscription %s by %s", transferSubscription.getId(), userId), ex);
        }
    }

    @Override
    public String exportAsCsv(Collection<SubscriptionEntity> subscriptions, Map<String, Map<String, Object>> metadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("Plan");
        sb.append(';');
        sb.append("Application");
        sb.append(';');
        sb.append("Creation date");
        sb.append(';');
        sb.append("Process date");
        sb.append(';');
        sb.append("Start date");
        sb.append(';');
        sb.append("End date date");
        sb.append(';');
        sb.append("Status");
        sb.append(System.lineSeparator());
        if (subscriptions == null || subscriptions.isEmpty()) {
            return sb.toString();
        }
        for (SubscriptionEntity subscription : subscriptions) {
            Map<String, Object> plan = metadata.get(subscription.getPlan());
            sb.append(this.getName(plan));
            sb.append(';');
            Map<String, Object> application = metadata.get(subscription.getApplication());
            sb.append(this.getName(application));
            sb.append(';');
            if (subscription.getCreatedAt() != null) {
                sb.append(dateFormatter.format(subscription.getCreatedAt()));
                sb.append(';');
            }
            if (subscription.getProcessedAt() != null) {
                sb.append(dateFormatter.format(subscription.getProcessedAt()));
                sb.append(';');
            }
            if (subscription.getStartingAt() != null) {
                sb.append(dateFormatter.format(subscription.getStartingAt()));
                sb.append(';');
            }
            if (subscription.getEndingAt() != null) {
                sb.append(dateFormatter.format(subscription.getEndingAt()));
                sb.append(';');
            }
            sb.append(subscription.getStatus());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    public Set<String> findReferenceIdsOrderByNumberOfSubscriptions(SubscriptionQuery query, Order order) {
        try {
            return this.subscriptionRepository.findReferenceIdsOrderByNumberOfSubscriptions(this.toSubscriptionCriteriaBuilder(query).build(), order);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to findReferenceIdsOrderByNumberOfSubscriptions for subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to findReferenceIdsOrderByNumberOfSubscriptions for subscriptions: %s", query), ex);
        }
    }

    private String getName(Object map) {
        return map == null ? "" : ((Map)map).get("name").toString();
    }

    @Override
    public Metadata getMetadata(ExecutionContext executionContext, SubscriptionMetadataQuery query) {
        Metadata metadata = new Metadata();
        Collection subscriptions = query.getSubscriptions();
        Optional<Map> applicationsById = query.ifApplications().map(withApplications -> {
            Set<String> appIds = subscriptions.stream().map(SubscriptionEntity::getApplication).collect(Collectors.toSet());
            return this.applicationService.findByIds(new ExecutionContext(query.getOrganization(), query.getEnvironment()), appIds).stream().collect(Collectors.toMap(ApplicationListItem::getId, Function.identity()));
        });
        Optional<Map> apisById = query.ifApis().map(withApis -> {
            Set<String> apiIds = subscriptions.stream().map(SubscriptionEntity::getApi).collect(Collectors.toSet());
            return this.apiService.findByEnvironmentAndIdIn(executionContext, apiIds).stream().collect(Collectors.toMap(ApiEntity::getId, Function.identity()));
        });
        Optional<Map> plansById = query.ifPlans().map(withPlans -> {
            Set<String> planIds = subscriptions.stream().map(SubscriptionEntity::getPlan).collect(Collectors.toSet());
            return this.planService.findByIdIn(executionContext, planIds).stream().collect(Collectors.toMap(PlanEntity::getId, Function.identity()));
        });
        Optional<Map> subscribersById = query.ifSubscribers().map(withSubscribers -> {
            Set<String> subscriberIds = subscriptions.stream().map(SubscriptionEntity::getSubscribedBy).collect(Collectors.toSet());
            return this.userService.findByIds(executionContext, subscriberIds).stream().collect(Collectors.toMap(UserEntity::getId, Function.identity()));
        });
        subscriptions.forEach(subscription -> {
            applicationsById.ifPresent(byId -> this.fillApplicationMetadata((Map<String, ApplicationListItem>)byId, metadata, (SubscriptionEntity)subscription));
            apisById.ifPresent(byId -> this.fillApiMetadata(executionContext, (Map<String, ApiEntity>)byId, metadata, (SubscriptionEntity)subscription, query));
            plansById.ifPresent(byId -> this.fillPlanMetadata((Map<String, PlanEntity>)byId, metadata, (SubscriptionEntity)subscription));
            subscribersById.ifPresent(byId -> this.fillSubscribersMetadata((Map<String, UserEntity>)byId, metadata, (SubscriptionEntity)subscription));
        });
        return metadata;
    }

    private Metadata fillApplicationMetadata(Map<String, ApplicationListItem> applications, Metadata metadata, SubscriptionEntity subscription) {
        if (applications.containsKey(subscription.getApplication())) {
            ApplicationListItem application = applications.get(subscription.getApplication());
            metadata.put(application.getId(), "name", (Object)application.getName());
        }
        return metadata;
    }

    private Metadata fillPlanMetadata(Map<String, PlanEntity> plans, Metadata metadata, SubscriptionEntity subscription) {
        if (plans.containsKey(subscription.getPlan())) {
            PlanEntity plan = plans.get(subscription.getPlan());
            metadata.put(plan.getId(), "name", (Object)plan.getName());
            metadata.put(plan.getId(), "securityType", (Object)plan.getSecurity());
        }
        return metadata;
    }

    private Metadata fillApiMetadata(ExecutionContext executionContext, Map<String, ApiEntity> apis, Metadata metadata, SubscriptionEntity subscription, SubscriptionMetadataQuery query) {
        if (apis.containsKey(subscription.getApi())) {
            ApiEntity api = apis.get(subscription.getApi());
            metadata.put(api.getId(), "name", (Object)api.getName());
            if (query.hasDetails()) {
                metadata.put(api.getId(), "state", (Object)api.getLifecycleState());
                metadata.put(api.getId(), "version", (Object)api.getVersion());
                this.apiService.calculateEntrypoints(executionContext, api);
                metadata.put(api.getId(), "entrypoints", (Object)api.getEntrypoints());
            }
            query.getApiDelegate().forEach(delegate -> delegate.apply(metadata, api));
        }
        return metadata;
    }

    private Metadata fillSubscribersMetadata(Map<String, UserEntity> users, Metadata metadata, SubscriptionEntity subscription) {
        if (users.containsKey(subscription.getSubscribedBy())) {
            UserEntity user = users.get(subscription.getSubscribedBy());
            metadata.put(user.getId(), "name", (Object)user.getDisplayName());
        }
        return metadata;
    }

    private SubscriptionEntity convert(Subscription subscription) {
        SubscriptionEntity entity = new SubscriptionEntity();
        entity.setId(subscription.getId());
        entity.setApi(subscription.getApi());
        entity.setPlan(subscription.getPlan());
        entity.setProcessedAt(subscription.getProcessedAt());
        entity.setStatus(SubscriptionStatus.valueOf((String)subscription.getStatus().name()));
        entity.setProcessedBy(subscription.getProcessedBy());
        entity.setRequest(subscription.getRequest());
        entity.setReason(subscription.getReason());
        entity.setApplication(subscription.getApplication());
        entity.setStartingAt(subscription.getStartingAt());
        entity.setEndingAt(subscription.getEndingAt());
        entity.setCreatedAt(subscription.getCreatedAt());
        entity.setUpdatedAt(subscription.getUpdatedAt());
        entity.setSubscribedBy(subscription.getSubscribedBy());
        entity.setClosedAt(subscription.getClosedAt());
        entity.setClientId(subscription.getClientId());
        entity.setPausedAt(subscription.getPausedAt());
        entity.setDaysToExpirationOnLastNotification(subscription.getDaysToExpirationOnLastNotification());
        return entity;
    }

    private void createAudit(ExecutionContext executionContext, String apiId, String applicationId, Audit.AuditEvent event, Date createdAt, Subscription oldValue, Subscription newValue) {
        this.auditService.createApiAuditLog(executionContext, apiId, Collections.singletonMap(Audit.AuditProperties.APPLICATION, applicationId), event, createdAt, oldValue, newValue);
        this.auditService.createApplicationAuditLog(executionContext, applicationId, Collections.singletonMap(Audit.AuditProperties.API, apiId), event, createdAt, oldValue, newValue);
    }

    private long countApiKeySubscriptions(ExecutionContext executionContext, ApplicationEntity application) {
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApplication(application.getId());
        return this.search(executionContext, subscriptionQuery).stream().filter(subscription -> this.planService.findById(executionContext, subscription.getPlan()).getSecurity() == PlanSecurityType.API_KEY).count();
    }

    private Stream<ApiKeyEntity> streamActiveApiKeys(ExecutionContext executionContext, String subscriptionId) {
        return this.apiKeyService.findBySubscription(executionContext, subscriptionId).stream().filter(apiKey -> !apiKey.isRevoked() && !apiKey.isExpired());
    }
}

