/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiExportService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.PageConverter;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiExportServiceImpl
extends AbstractService
implements ApiExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiExportServiceImpl.class);
    private final ObjectMapper objectMapper;
    private final PageService pageService;
    private final PlanService planService;
    private final ApiService apiService;
    private final ApiConverter apiConverter;
    private final PlanConverter planConverter;
    private final PageConverter pageConverter;

    public ApiExportServiceImpl(ObjectMapper objectMapper, PageService pageService, PlanService planService, ApiService apiService, ApiConverter apiConverter, PlanConverter planConverter, PageConverter pageConverter) {
        this.objectMapper = objectMapper;
        this.pageService = pageService;
        this.planService = planService;
        this.apiService = apiService;
        this.apiConverter = apiConverter;
        this.planConverter = planConverter;
        this.pageConverter = pageConverter;
    }

    @Override
    public String exportAsJson(ExecutionContext executionContext, String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.apiService.findById(executionContext, apiId);
        this.generateAndSaveCrossId(executionContext, apiEntity);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    private void generateAndSaveCrossId(ExecutionContext executionContext, ApiEntity api) {
        if (StringUtils.isEmpty((CharSequence)api.getCrossId())) {
            api.setCrossId(UuidString.generateRandom());
            this.apiService.update(executionContext, api.getId(), this.apiConverter.toUpdateApiEntity(api));
        }
        this.planService.findByApi(executionContext, api.getId()).forEach(plan -> this.generateAndSaveCrossId(executionContext, (PlanEntity)plan));
        this.pageService.findByApi(executionContext.getEnvironmentId(), api.getId()).forEach(page -> this.generateAndSaveCrossId(executionContext, (PageEntity)page));
    }

    private void generateAndSaveCrossId(ExecutionContext executionContext, PlanEntity plan) {
        if (StringUtils.isEmpty((CharSequence)plan.getCrossId())) {
            plan.setCrossId(UuidString.generateRandom());
            this.planService.update(executionContext, this.planConverter.toUpdatePlanEntity(plan));
        }
    }

    private void generateAndSaveCrossId(ExecutionContext executionContext, PageEntity page) {
        if (StringUtils.isEmpty((CharSequence)page.getCrossId())) {
            page.setCrossId(UuidString.generateRandom());
            UpdatePageEntity updatePageEntity = new UpdatePageEntity();
            updatePageEntity.setCrossId(page.getCrossId());
            this.pageService.update(executionContext, page.getId(), updatePageEntity, true);
        }
    }
}

