/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.ResourceService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ResourceServiceImpl
extends AbstractPluginService<ResourcePlugin, PlatformPluginEntity>
implements ResourceService {
    private final JsonSchemaService jsonSchemaService;

    public ResourceServiceImpl(JsonSchemaService jsonSchemaService) {
        this.jsonSchemaService = jsonSchemaService;
    }

    @Override
    public Set<PlatformPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public PlatformPluginEntity findById(String resource) {
        ResourcePlugin resourceDefinition = (ResourcePlugin)super.get(resource);
        return this.convert((Plugin)resourceDefinition);
    }

    @Override
    public void validateResourceConfiguration(Resource resource) {
        String schema = this.getSchema(resource.getType());
        this.jsonSchemaService.validate(schema, resource.getConfiguration());
    }
}

