/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.gravitee.rest.api.model.JsonPatch;
import io.gravitee.rest.api.service.JsonPatchService;
import io.gravitee.rest.api.service.exceptions.JsonPatchTestFailedException;
import io.gravitee.rest.api.service.exceptions.JsonPatchUnsafeException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.sanitizer.HtmlSanitizer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonPatchServiceImpl
extends AbstractService
implements JsonPatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPatchServiceImpl.class);
    private static final Configuration CONFIGURATION = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
    private static final Configuration TEST_CONFIGURATION = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
    private final ObjectMapper objectMapper;

    public JsonPatchServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String execute(String json, Collection<JsonPatch> jsonPatches) {
        try {
            DocumentContext apiDefinitionParsed = JsonPath.parse((String)json);
            Object apiDefinitionToUpdate = this.transform(jsonPatches, apiDefinitionParsed.json());
            return this.objectMapper.writeValueAsString(apiDefinitionToUpdate);
        }
        catch (JsonProcessingException | InvalidPathException ex) {
            LOGGER.error("An error occurs while trying to execute json patches", ex);
            throw new TechnicalManagementException("An error occurs while trying to execute json patches", ex);
        }
    }

    private Object transform(Collection<JsonPatch> jsonPatches, Object apiDefinitionToUpdate) {
        for (JsonPatch jsonPatch : jsonPatches) {
            apiDefinitionToUpdate = this.execute(apiDefinitionToUpdate, jsonPatch);
        }
        return apiDefinitionToUpdate;
    }

    private Object execute(Object jsonObject, JsonPatch jsonPatch) {
        Object read;
        String jsonPath = jsonPatch.getJsonPath();
        this.checkSafe(jsonPath);
        Serializable value = jsonPatch.getValue();
        this.checkSafe(value);
        DocumentContext parse = JsonPath.parse((Object)jsonObject);
        Object json = parse.json();
        JsonPath compile = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        if (JsonPatch.Operation.REPLACE.equals((Object)jsonPatch.getOperation())) {
            return compile.set(json, (Object)value, CONFIGURATION);
        }
        if (JsonPatch.Operation.ADD.equals((Object)jsonPatch.getOperation())) {
            return compile.add(json, (Object)value, CONFIGURATION);
        }
        if (JsonPatch.Operation.REMOVE.equals((Object)jsonPatch.getOperation())) {
            return compile.delete(json, CONFIGURATION);
        }
        if (!(!JsonPatch.Operation.TEST.equals((Object)jsonPatch.getOperation()) || (read = compile.read(json, TEST_CONFIGURATION)) == null && "null".equals(value) || read != null && read.equals(value))) {
            throw new JsonPatchTestFailedException(jsonPatch);
        }
        return json;
    }

    private void checkSafe(Object value) {
        HtmlSanitizer.SanitizeInfos sanitizeInfos;
        if (value instanceof Map) {
            ((Map)value).keySet().forEach(this::checkSafe);
            ((Map)value).values().forEach(this::checkSafe);
        } else if (value instanceof List) {
            ((List)value).forEach(this::checkSafe);
        } else if (value != null && !(sanitizeInfos = HtmlSanitizer.isSafe(value.toString())).isSafe()) {
            throw new JsonPatchUnsafeException(sanitizeInfos.getRejectedMessage());
        }
    }
}

