/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Rule;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PlanType;
import io.gravitee.rest.api.model.PlanValidationType;
import io.gravitee.rest.api.model.UpdatePlanEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanConverter.class);
    @Autowired
    private ObjectMapper objectMapper;

    public PlanEntity toPlanEntity(io.gravitee.repository.management.model.Plan plan) {
        return this.toPlanEntity(plan, null);
    }

    public PlanEntity toPlanEntity(io.gravitee.repository.management.model.Plan plan, ApiEntity apiEntity) {
        PlanEntity entity = new PlanEntity();
        entity.setId(plan.getId());
        entity.setCrossId(plan.getCrossId());
        entity.setName(plan.getName());
        entity.setDescription(plan.getDescription());
        entity.setApi(plan.getApi());
        entity.setCreatedAt(plan.getCreatedAt());
        entity.setUpdatedAt(plan.getUpdatedAt());
        entity.setOrder(plan.getOrder());
        entity.setExcludedGroups(plan.getExcludedGroups());
        if (plan.getDefinition() != null && !plan.getDefinition().isEmpty()) {
            try {
                HashMap rules = (HashMap)this.objectMapper.readValue(plan.getDefinition(), (TypeReference)new TypeReference<HashMap<String, List<Rule>>>(){});
                entity.setPaths((Map)rules);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating policy definition", (Throwable)ioe);
            }
        }
        if (apiEntity != null && DefinitionVersion.V2.equals((Object)DefinitionVersion.valueOfLabel((String)apiEntity.getGraviteeDefinitionVersion()))) {
            Optional<List> planFlows = apiEntity.getPlans().stream().filter(pl -> plan.getId() != null && plan.getId().equals(pl.getId())).map(Plan::getFlows).findFirst();
            planFlows.ifPresent(arg_0 -> ((PlanEntity)entity).setFlows(arg_0));
        }
        entity.setType(PlanType.valueOf((String)plan.getType().name()));
        if (plan.getStatus() != null) {
            entity.setStatus(PlanStatus.valueOf((String)plan.getStatus().name()));
        } else {
            entity.setStatus(PlanStatus.PUBLISHED);
        }
        if (plan.getSecurity() != null) {
            entity.setSecurity(PlanSecurityType.valueOf((String)plan.getSecurity().name()));
        } else {
            entity.setSecurity(PlanSecurityType.API_KEY);
        }
        entity.setSecurityDefinition(plan.getSecurityDefinition());
        entity.setClosedAt(plan.getClosedAt());
        entity.setNeedRedeployAt(plan.getNeedRedeployAt() == null ? plan.getUpdatedAt() : plan.getNeedRedeployAt());
        entity.setPublishedAt(plan.getPublishedAt());
        entity.setValidation(PlanValidationType.valueOf((String)plan.getValidation().name()));
        entity.setCharacteristics(plan.getCharacteristics());
        entity.setCommentRequired(plan.isCommentRequired());
        entity.setCommentMessage(plan.getCommentMessage());
        entity.setTags(plan.getTags());
        entity.setSelectionRule(plan.getSelectionRule());
        entity.setGeneralConditions(plan.getGeneralConditions());
        return entity;
    }

    public UpdatePlanEntity toUpdatePlanEntity(PlanEntity planEntity) {
        UpdatePlanEntity updatePlanEntity = new UpdatePlanEntity();
        updatePlanEntity.setId(planEntity.getId());
        updatePlanEntity.setCrossId(planEntity.getCrossId());
        updatePlanEntity.setName(planEntity.getName());
        updatePlanEntity.setDescription(planEntity.getDescription());
        updatePlanEntity.setValidation(planEntity.getValidation());
        if (planEntity.getPaths() != null) {
            updatePlanEntity.setPaths(planEntity.getPaths());
        }
        updatePlanEntity.setCharacteristics(planEntity.getCharacteristics());
        updatePlanEntity.setOrder(planEntity.getOrder());
        updatePlanEntity.setExcludedGroups(planEntity.getExcludedGroups());
        updatePlanEntity.setSecurityDefinition(planEntity.getSecurityDefinition());
        updatePlanEntity.setCommentRequired(planEntity.isCommentRequired());
        updatePlanEntity.setCommentMessage(planEntity.getCommentMessage());
        updatePlanEntity.setGeneralConditions(planEntity.getGeneralConditions());
        updatePlanEntity.setTags(planEntity.getTags());
        updatePlanEntity.setSelectionRule(planEntity.getSelectionRule());
        updatePlanEntity.setFlows(planEntity.getFlows());
        return updatePlanEntity;
    }

    public NewPlanEntity toNewPlanEntity(PlanEntity planEntity) {
        return this.toNewPlanEntity(planEntity, false);
    }

    public NewPlanEntity toNewPlanEntity(PlanEntity planEntity, boolean resetCrossId) {
        NewPlanEntity newPlanEntity = new NewPlanEntity();
        newPlanEntity.setId(planEntity.getId());
        newPlanEntity.setCrossId(resetCrossId ? null : planEntity.getCrossId());
        newPlanEntity.setApi(planEntity.getApi());
        newPlanEntity.setName(planEntity.getName());
        newPlanEntity.setDescription(planEntity.getDescription());
        newPlanEntity.setOrder(planEntity.getOrder());
        if (planEntity.getValidation() != null) {
            newPlanEntity.setValidation(planEntity.getValidation());
        }
        if (planEntity.getSecurity() != null) {
            newPlanEntity.setSecurity(planEntity.getSecurity());
        }
        newPlanEntity.setSecurityDefinition(planEntity.getSecurityDefinition());
        if (planEntity.getType() != null) {
            newPlanEntity.setType(planEntity.getType());
        }
        if (planEntity.getStatus() != null) {
            newPlanEntity.setStatus(planEntity.getStatus());
        }
        if (planEntity.getPaths() != null) {
            newPlanEntity.setPaths(planEntity.getPaths());
        }
        if (planEntity.getFlows() != null) {
            newPlanEntity.setFlows(planEntity.getFlows());
        }
        if (planEntity.getType() != null) {
            newPlanEntity.setType(planEntity.getType());
        }
        newPlanEntity.setCharacteristics(planEntity.getCharacteristics());
        newPlanEntity.setExcludedGroups(planEntity.getExcludedGroups());
        newPlanEntity.setCommentRequired(planEntity.isCommentRequired());
        newPlanEntity.setCommentMessage(planEntity.getCommentMessage());
        newPlanEntity.setGeneralConditions(planEntity.getGeneralConditions());
        newPlanEntity.setTags(planEntity.getTags());
        newPlanEntity.setSelectionRule(planEntity.getSelectionRule());
        return newPlanEntity;
    }

    public io.gravitee.repository.management.model.Plan toPlan(NewPlanEntity newPlan, DefinitionVersion graviteeDefinitionVersion) throws JsonProcessingException {
        io.gravitee.repository.management.model.Plan plan = new io.gravitee.repository.management.model.Plan();
        plan.setId(newPlan.getId());
        plan.setCrossId(newPlan.getCrossId());
        plan.setApi(newPlan.getApi());
        plan.setName(newPlan.getName());
        plan.setDescription(newPlan.getDescription());
        plan.setCreatedAt(new Date());
        plan.setUpdatedAt(plan.getCreatedAt());
        plan.setNeedRedeployAt(plan.getCreatedAt());
        plan.setType(Plan.PlanType.valueOf((String)newPlan.getType().name()));
        plan.setSecurity(Plan.PlanSecurityType.valueOf((String)newPlan.getSecurity().name()));
        plan.setSecurityDefinition(newPlan.getSecurityDefinition());
        plan.setStatus(Plan.Status.valueOf((String)newPlan.getStatus().name()));
        plan.setExcludedGroups(newPlan.getExcludedGroups());
        plan.setCommentRequired(newPlan.isCommentRequired());
        plan.setCommentMessage(newPlan.getCommentMessage());
        plan.setTags(newPlan.getTags());
        plan.setSelectionRule(newPlan.getSelectionRule());
        plan.setGeneralConditions(newPlan.getGeneralConditions());
        plan.setOrder(newPlan.getOrder());
        if (newPlan.getStatus() == PlanStatus.PUBLISHED) {
            plan.setPublishedAt(new Date());
        }
        if (plan.getSecurity() == Plan.PlanSecurityType.KEY_LESS) {
            plan.setValidation(Plan.PlanValidationType.AUTO);
        } else {
            plan.setValidation(Plan.PlanValidationType.valueOf((String)newPlan.getValidation().name()));
        }
        plan.setCharacteristics(newPlan.getCharacteristics());
        if (!DefinitionVersion.V2.equals((Object)graviteeDefinitionVersion)) {
            String planPolicies = this.objectMapper.writeValueAsString((Object)newPlan.getPaths());
            plan.setDefinition(planPolicies);
        }
        return plan;
    }
}

